/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.combat.abilities.armor;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.item.EquipmentUtil;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;

public interface NeptuneArmor {
    public static void boostWaterSwimming(LivingEntity entity) {
        Player player;
        if (EquipmentUtil.hasFullNeptuneSet(entity) && entity.isInWaterOrBubble()) {
            if (entity instanceof Player) {
                player = (Player)entity;
                AetherPlayerAttachment data = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
                float defaultBoost = NeptuneArmor.boostWithDepthStrider((LivingEntity)player);
                data.setNeptuneSubmergeLength(Math.min(data.getNeptuneSubmergeLength() + 0.1, 1.0));
                player.moveRelative(0.04f * (defaultBoost *= (float)data.getNeptuneSubmergeLength()), new Vec3((double)player.xxa, (double)player.yya, (double)player.zza));
                if (player.isSwimming() || player.getDeltaMovement().y() > 0.0 || player.isCrouching()) {
                    player.move(MoverType.SELF, player.getDeltaMovement().multiply(0.0, (double)defaultBoost, 0.0));
                }
            } else {
                float defaultBoost = NeptuneArmor.boostWithDepthStrider(entity);
                entity.moveRelative(0.04f * defaultBoost, new Vec3((double)entity.xxa, (double)entity.yya, (double)entity.zza));
                if (entity.isSwimming() || entity.getDeltaMovement().y() > 0.0 || entity.isCrouching()) {
                    entity.move(MoverType.SELF, entity.getDeltaMovement().multiply(0.0, (double)defaultBoost, 0.0));
                }
            }
        }
        if (!(EquipmentUtil.hasFullNeptuneSet(entity) && entity.isInWaterOrBubble() || !(entity instanceof Player))) {
            player = (Player)entity;
            ((AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER)).setNeptuneSubmergeLength(0.0);
        }
    }

    private static float boostWithDepthStrider(LivingEntity entity) {
        float defaultBoost = 0.4f;
        float depthStriderModifier = Math.min((float)EnchantmentHelper.getEnchantmentLevel((Holder)entity.level().holderOrThrow(Enchantments.INFINITY), (LivingEntity)entity), 3.0f);
        if (depthStriderModifier > 0.0f) {
            defaultBoost += depthStriderModifier * 0.4f;
        }
        if (entity.isSwimming() && entity.getDeltaMovement().y() < 0.0) {
            defaultBoost *= 0.5f;
        }
        return defaultBoost;
    }
}

