/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.combat.loot;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.item.combat.AetherItemTiers;
import com.aetherteam.aether.mixin.mixins.common.accessor.ZombifiedPiglinAccessor;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class PigSlayerItem
extends SwordItem {
    public PigSlayerItem() {
        super((Tier)AetherItemTiers.PIG_SLAYER, new Item.Properties().rarity(AetherItems.AETHER_LOOT).attributes(SwordItem.createAttributes((Tier)AetherItemTiers.PIG_SLAYER, (float)3.0f, (float)-2.4f)));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (EquipmentUtil.isFullStrength(attacker) && target.getType().is(AetherTags.Entities.PIGS)) {
            Level player;
            if (target instanceof ZombifiedPiglin) {
                ZombifiedPiglin zombifiedPiglin = (ZombifiedPiglin)target;
                if (!(attacker instanceof Player) || !(player = (Player)attacker).isCreative()) {
                    ZombifiedPiglinAccessor zombifiedPiglinAccessor = (ZombifiedPiglinAccessor)zombifiedPiglin;
                    zombifiedPiglin.setTarget(attacker);
                    zombifiedPiglinAccessor.callAlertOthers();
                }
            }
            if ((player = target.level()) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)player;
                for (int i = 0; i < 20; ++i) {
                    double d0 = level.getRandom().nextGaussian() * 0.02;
                    double d1 = level.getRandom().nextGaussian() * 0.02;
                    double d2 = level.getRandom().nextGaussian() * 0.02;
                    double d3 = 5.0;
                    double x = target.getX() + (double)(level.getRandom().nextFloat() * target.getBbWidth()) * 2.0 - (double)target.getBbWidth() - d0 * d3;
                    double y = target.getY() + (double)(level.getRandom().nextFloat() * target.getBbHeight()) - d1 * d3;
                    double z = target.getZ() + (double)(level.getRandom().nextFloat() * target.getBbWidth()) * 2.0 - (double)target.getBbWidth() - d2 * d3;
                    level.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 1, d0, d1, d2, 0.0);
                }
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        LivingEntity target = event.getEntity();
        DamageSource damageSource = event.getSource();
        float damage = event.getNewDamage();
        if (PigSlayerItem.canPerformAbility(target, damageSource)) {
            event.setNewDamage(damage + 16.0f);
        }
    }

    private static boolean canPerformAbility(LivingEntity target, DamageSource source) {
        LivingEntity attacker;
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity && EquipmentUtil.isFullStrength(attacker = (LivingEntity)entity) && target.getType().is(AetherTags.Entities.PIGS)) {
            return attacker.getMainHandItem().is((Item)AetherItems.PIG_SLAYER.get());
        }
        return false;
    }
}

