/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.loot.functions;

import com.aetherteam.aether.entity.block.TntPresent;
import com.aetherteam.aether.loot.functions.AetherLootFunctions;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class SpawnTNT
extends LootItemConditionalFunction {
    public static final MapCodec<SpawnTNT> CODEC = RecordCodecBuilder.mapCodec(instance -> SpawnTNT.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SpawnTNT::new));

    protected SpawnTNT(List<LootItemCondition> conditions) {
        super(conditions);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        ServerLevel serverLevel = context.getLevel();
        Vec3 originVec = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        if (originVec != null) {
            TntPresent tnt = new TntPresent((Level)serverLevel, originVec.x(), originVec.y(), originVec.z(), null);
            serverLevel.addFreshEntity((Entity)tnt);
            serverLevel.playSound(null, BlockPos.containing((Position)originVec), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return LootItemConditionalFunction.simpleBuilder(SpawnTNT::new);
    }

    public LootItemFunctionType<SpawnTNT> getType() {
        return (LootItemFunctionType)AetherLootFunctions.SPAWN_TNT.get();
    }
}

