/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin;

import com.aetherteam.aether.item.accessories.cape.CapeItem;
import com.aetherteam.aether.item.accessories.gloves.GlovesItem;
import com.aetherteam.aether.item.accessories.pendant.PendantItem;
import com.aetherteam.aether.mixin.mixins.common.accessor.MinecraftServerAccessor;
import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.nio.file.Path;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class AetherMixinHooks {
    private static final ResourceLocation SWUFF_CAPE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/models/accessory/capes/swuff_accessory.png");

    public static ItemStack isCapeVisible(LivingEntity livingEntity) {
        AccessoriesContainer accessoriesContainer;
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)livingEntity);
        if (accessories != null && (accessoriesContainer = accessories.getContainer(CapeItem.getStaticIdentifier())) != null) {
            ExpandedSimpleContainer simpleAccessoriesContainer = accessoriesContainer.getAccessories();
            ExpandedSimpleContainer simpleCosmeticsContainer = accessoriesContainer.getCosmeticAccessories();
            Pair stack = StreamSupport.stream(simpleAccessoriesContainer.spliterator(), true).findFirst().orElse(null);
            Pair cosmeticStack = StreamSupport.stream(simpleCosmeticsContainer.spliterator(), true).findFirst().orElse(null);
            if (cosmeticStack != null && !((ItemStack)cosmeticStack.getSecond()).isEmpty() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                stack = cosmeticStack;
            }
            if (stack != null && accessoriesContainer.shouldRender(((Integer)stack.getFirst()).intValue())) {
                return (ItemStack)stack.getSecond();
            }
        }
        return ItemStack.EMPTY;
    }

    public static ResourceLocation getCapeTexture(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof CapeItem) {
            CapeItem capeItem = (CapeItem)item;
            if (stack.getHoverName().getString().equalsIgnoreCase("swuff_'s cape")) {
                return SWUFF_CAPE_LOCATION;
            }
            return capeItem.getCapeTexture();
        }
        return null;
    }

    public static boolean canUnlockLevel(Path basePath) {
        if (Minecraft.getInstance().screen != null && Minecraft.getInstance().screen instanceof SelectWorldScreen && Minecraft.getInstance().getSingleplayerServer() != null) {
            return basePath.getFileName().toString().equals(((MinecraftServerAccessor)Minecraft.getInstance().getSingleplayerServer()).aether$getStorageSource().getLevelId());
        }
        return false;
    }

    public static boolean canReplaceCurrentAccessory(Mob mob, ItemStack candidate, ItemStack existing) {
        if (EnchantmentHelper.hasAnyEnchantments((ItemStack)existing)) {
            return false;
        }
        Item item = candidate.getItem();
        if (item instanceof GlovesItem) {
            GlovesItem candidateGloves = (GlovesItem)item;
            Item item2 = existing.getItem();
            if (!(item2 instanceof GlovesItem)) {
                return true;
            }
            GlovesItem existingGloves = (GlovesItem)item2;
            if (candidateGloves.getDamage() != existingGloves.getDamage()) {
                return candidateGloves.getDamage() > existingGloves.getDamage();
            }
            return mob.canReplaceEqualItem(candidate, existing);
        }
        if (candidate.getItem() instanceof PendantItem) {
            if (!(existing.getItem() instanceof PendantItem)) {
                return true;
            }
            return mob.canReplaceEqualItem(candidate, existing);
        }
        return false;
    }

    public static SlotTypeReference getIdentifierForItem(LivingEntity livingEntity, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof GlovesItem) {
            GlovesItem glovesItem = (GlovesItem)item;
            return glovesItem.getIdentifier();
        }
        item = stack.getItem();
        if (item instanceof PendantItem) {
            PendantItem pendantItem = (PendantItem)item;
            if (livingEntity.getType() == EntityType.PIGLIN || livingEntity.getType() == EntityType.ZOMBIFIED_PIGLIN) {
                return pendantItem.getIdentifier();
            }
        }
        return null;
    }

    public static ItemStack getItemByIdentifier(LivingEntity livingEntity, SlotTypeReference identifier) {
        AccessoriesContainer accessoriesContainer;
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)livingEntity);
        if (accessories != null && (accessoriesContainer = accessories.getContainer(identifier)) != null) {
            return accessoriesContainer.getAccessories().getItem(0);
        }
        return ItemStack.EMPTY;
    }

    public static void setItemByIdentifier(LivingEntity livingEntity, ItemStack itemStack, SlotTypeReference identifier) {
        AccessoriesContainer accessoriesContainer;
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)livingEntity);
        if (accessories != null && (accessoriesContainer = accessories.getContainer(identifier)) != null) {
            accessoriesContainer.getAccessories().setItem(0, itemStack);
        }
    }
}

