/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.clientbound;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.entity.miscellaneous.CloudMinion;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CloudMinionPacket(int entityID, int rightCloudMinionID, int leftCloudMinionID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CloudMinionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"add_cloud_minions"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CloudMinionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CloudMinionPacket::entityID, (StreamCodec)ByteBufCodecs.INT, CloudMinionPacket::rightCloudMinionID, (StreamCodec)ByteBufCodecs.INT, CloudMinionPacket::leftCloudMinionID, CloudMinionPacket::new);

    public CustomPacketPayload.Type<CloudMinionPacket> type() {
        return TYPE;
    }

    public static void execute(CloudMinionPacket payload, IPayloadContext context) {
        Level level;
        Entity entity;
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && (entity = (level = Minecraft.getInstance().player.level()).getEntity(payload.entityID())) instanceof Player) {
            Player player = (Player)entity;
            entity = level.getEntity(payload.rightCloudMinionID());
            if (entity instanceof CloudMinion) {
                CloudMinion cloudMinionRight = (CloudMinion)entity;
                entity = level.getEntity(payload.leftCloudMinionID());
                if (entity instanceof CloudMinion) {
                    CloudMinion cloudMinionLeft = (CloudMinion)entity;
                    AetherPlayerAttachment data = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
                    if (data.getCloudMinions().isEmpty()) {
                        data.setCloudMinions(player, cloudMinionRight, cloudMinionLeft);
                    }
                }
            }
        }
    }
}

