/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.foliageplacer;

import com.aetherteam.aether.world.foliageplacer.AetherFoliagePlacerTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class GoldenOakFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<GoldenOakFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> GoldenOakFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and((App)IntProvider.codec((int)0, (int)24).fieldOf("trunk_height").forGetter(placer -> placer.trunkHeight)).apply((Applicative)instance, GoldenOakFoliagePlacer::new));
    private final IntProvider trunkHeight;

    public GoldenOakFoliagePlacer(IntProvider radius, IntProvider offset, IntProvider height) {
        super(radius, offset);
        this.trunkHeight = height;
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)AetherFoliagePlacerTypes.GOLDEN_OAK_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter foliageSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        for (int i = offset; i >= offset - foliageHeight; --i) {
            this.placeLeavesRow(level, foliageSetter, random, config, attachment.pos(), 4, i, attachment.doubleTrunk());
        }
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return 7;
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return Mth.square((int)localX) + Mth.square((int)(localY + 2)) + Mth.square((int)localZ) > 12 + random.nextInt(5);
    }
}

