/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.placementmodifier;

import com.aetherteam.aether.world.placementmodifier.AetherPlacementModifiers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ImprovedLayerPlacementModifier
extends PlacementModifier {
    public static final MapCodec<ImprovedLayerPlacementModifier> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Heightmap.Types.CODEC.fieldOf("heightmap").forGetter(modifier -> modifier.heightmap), (App)IntProvider.codec((int)0, (int)256).fieldOf("count").forGetter(modifier -> modifier.count), (App)Codec.INT.optionalFieldOf("verticalBounds", (Object)Integer.MIN_VALUE).forGetter(modifier -> modifier.verticalBounds)).apply((Applicative)codec, ImprovedLayerPlacementModifier::new));
    private final Heightmap.Types heightmap;
    private final IntProvider count;
    private final int verticalBounds;

    private ImprovedLayerPlacementModifier(Heightmap.Types heightmap, IntProvider count, int verticalBounds) {
        this.heightmap = heightmap;
        this.count = count;
        this.verticalBounds = verticalBounds;
    }

    public static ImprovedLayerPlacementModifier of(Heightmap.Types heightmap, IntProvider count, int verticalBounds) {
        return new ImprovedLayerPlacementModifier(heightmap, count, verticalBounds);
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        boolean flag;
        Stream.Builder<BlockPos> builder = Stream.builder();
        int i = 0;
        do {
            flag = false;
            for (int j = 0; j < this.count.sample(random); ++j) {
                int z;
                int height;
                int x = random.nextInt(16) + pos.getX();
                BlockPos blockPos = this.findOnGroundPosition(context, new BlockPos(x, height = context.getHeight(this.heightmap, x, z = random.nextInt(16) + pos.getZ()), z), i);
                if (blockPos == null) continue;
                builder.add(blockPos);
                flag = true;
            }
            ++i;
        } while (flag);
        return builder.build();
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)AetherPlacementModifiers.IMPROVED_LAYER_PLACEMENT.get();
    }

    @Nullable
    private BlockPos findOnGroundPosition(PlacementContext context, BlockPos pos, int count) {
        int y;
        int i = 0;
        int x = pos.getX();
        int z = pos.getZ();
        for (int j = y = pos.getY(); j >= context.getMinBuildHeight() + 1; --j) {
            BlockPos blockPos = new BlockPos(x, j, z);
            BlockState blockState = context.getBlockState(blockPos);
            BlockState belowState = context.getBlockState(blockPos.below());
            if (!blockState.isAir() || !this.isSolid(belowState) || belowState.is(Blocks.BEDROCK) || !this.checkVerticalBounds(context, blockPos)) continue;
            if (i == count) {
                return blockPos;
            }
            ++i;
        }
        return null;
    }

    private boolean checkVerticalBounds(PlacementContext context, BlockPos pos) {
        int i = pos.getX();
        int j = pos.getZ();
        int k = pos.getY();
        boolean flag = true;
        for (int y = k; y < k + this.verticalBounds; ++y) {
            BlockPos blockPos = new BlockPos(i, y, j);
            if (!this.isSolid(context.getBlockState(blockPos))) continue;
            flag = false;
        }
        return flag;
    }

    private boolean isSolid(BlockState state) {
        return !state.isAir() && !state.is(Blocks.WATER) && !state.is(Blocks.LAVA);
    }
}

