/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.mobeffect;

import artifacts.component.ability.CompositeAbility;
import artifacts.component.ability.EntityCondition;
import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.mobeffect.MobEffectProvider;
import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModDataComponents;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;

public record PostEatingEffects(List<Entry> entries) implements CompositeAbility<Entry>
{
    public static final Codec<PostEatingEffects> CODEC = CompositeAbility.codec(Entry.CODEC, PostEatingEffects::new, PostEatingEffects::entries);
    public static final StreamCodec<RegistryFriendlyByteBuf, PostEatingEffects> STREAM_CODEC = CompositeAbility.streamCodec(Entry.STREAM_CODEC, PostEatingEffects::new, PostEatingEffects::entries);

    public static void applyEffects(LivingEntity entity, FoodProperties properties) {
        int n;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            n = 20 - player.getFoodData().getFoodLevel();
        } else {
            n = 20;
        }
        int foodPointsMissing = n;
        int foodPointsRestored = Math.min(properties.nutrition(), foodPointsMissing);
        PostEatingEffects.applyEffects(entity, foodPointsRestored);
    }

    public static void applyEffects(LivingEntity entity, int foodPointsRestored) {
        if (foodPointsRestored > 0) {
            EquipmentHelper.iterateAbilities(ModDataComponents.POST_EATING_EFFECTS.get(), entity, true, true, (ability, stack) -> {
                for (Entry entry : ability.entries) {
                    entity.addEffect(entry.provider().createEffect(foodPointsRestored));
                }
            });
        }
    }

    public record Entry(MobEffectProvider provider) implements EquipmentAbility
    {
        public static final Codec<Entry> CODEC = MobEffectProvider.codec(false).xmap(Entry::new, Entry::provider);
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = MobEffectProvider.STREAM_CODEC.map(Entry::new, Entry::provider);

        @Override
        public boolean isNonCosmetic() {
            return this.provider().isNonCosmetic();
        }

        @Override
        public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
            if (this.provider.mobEffect().equals((Object)MobEffects.DIG_SPEED) && this.provider.condition() == EntityCondition.ALWAYS) {
                writer.add("haste", new Object[0]);
            }
        }
    }
}

