/*
 * Decompiled with CFR 0.152.
 */
package artifacts.event;

import artifacts.component.SwimData;
import artifacts.component.ability.SwimInAir;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModKeyMappings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SwimInAirInputHooks {
    private static boolean wasSwimKeyDown;

    public static void onClientTick(Minecraft instance) {
        LocalPlayer player = instance.player;
        if (player != null && player.input != null) {
            SwimInAirInputHooks.handleSwimInAirInput((Player)player);
        }
    }

    private static void handleSwimInAirInput(Player player) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData((LivingEntity)player);
        if (swimData == null) {
            return;
        }
        boolean isSwimKeyDown = ModKeyMappings.getHeliumFlamingoKey().isDown();
        boolean isSwimKeyPressed = isSwimKeyDown && !wasSwimKeyDown;
        wasSwimKeyDown = isSwimKeyDown;
        if (isSwimKeyPressed && (swimData.isSwimming() ? player.isSwimming() : SwimInAir.canSwim((LivingEntity)player))) {
            swimData.toggleSwimming(player);
            swimData.syncSwimming(player);
        }
    }
}

