/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge;

import artifacts.neoforge.data.Advancements;
import artifacts.neoforge.data.ConfiguredFeatures;
import artifacts.neoforge.data.DataMaps;
import artifacts.neoforge.data.ItemModels;
import artifacts.neoforge.data.Language;
import artifacts.neoforge.data.LootModifiers;
import artifacts.neoforge.data.LootTables;
import artifacts.neoforge.data.PlacedFeatures;
import artifacts.neoforge.data.SoundDefinitions;
import artifacts.neoforge.data.tags.BlockTags;
import artifacts.neoforge.data.tags.DamageTypeTags;
import artifacts.neoforge.data.tags.EntityTypeTags;
import artifacts.neoforge.data.tags.GameEventTags;
import artifacts.neoforge.data.tags.ItemTags;
import artifacts.neoforge.data.tags.MobEffectTags;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class ArtifactsData {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        BlockTags blockTags = new BlockTags(packOutput, lookupProvider, existingFileHelper);
        LootModifiers lootModifiers = new LootModifiers(packOutput, lookupProvider);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTags(packOutput, lookupProvider, blockTags.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)lootModifiers);
        generator.addProvider(event.includeServer(), (DataProvider)new LootTables(packOutput, existingFileHelper, lootModifiers, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTypeTags(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MobEffectTags(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DamageTypeTags(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new GameEventTags(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new SoundDefinitions(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Advancements(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMaps(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new Language(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(generator.getPackOutput(), event.getLookupProvider(), ArtifactsData.createLevelProvider(), Set.of("artifacts")));
    }

    public static RegistrySetBuilder createLevelProvider() {
        RegistrySetBuilder builder = new RegistrySetBuilder();
        builder.add(Registries.CONFIGURED_FEATURE, ConfiguredFeatures::create);
        builder.add(Registries.PLACED_FEATURE, PlacedFeatures::create);
        return builder;
    }
}

