/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.capabilities;

import com.buuz135.industrialforegoingsouls.block.tile.SoulLaserBaseBlockEntity;
import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.buuz135.industrialforegoingsouls.config.ConfigSoulLaserBase;

public class SLBSoulCap
implements ISoulHandler {
    private final SoulLaserBaseBlockEntity blockEntity;

    public SLBSoulCap(SoulLaserBaseBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Override
    public int getSoulTanks() {
        return 1;
    }

    @Override
    public int getSoulInTank(int tank) {
        return this.blockEntity.getSoulAmount();
    }

    @Override
    public int getTankCapacity(int tank) {
        return ConfigSoulLaserBase.SOUL_STORAGE_AMOUNT;
    }

    @Override
    public int fill(int amount, ISoulHandler.Action action) {
        return 0;
    }

    @Override
    public int drain(int maxDrain, ISoulHandler.Action action) {
        if (action.execute()) {
            return this.blockEntity.useSoul(maxDrain);
        }
        int oldAmount = this.blockEntity.getSoulAmount();
        int newAmount = Math.max(0, this.blockEntity.getSoulAmount() - maxDrain);
        return oldAmount - newAmount;
    }
}

