/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.client;

import com.buuz135.industrialforegoingsouls.block.tile.SoulLaserBaseBlockEntity;
import com.buuz135.industrialforegoingsouls.config.ConfigSoulLaserBase;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SculkSoulTankScreenAddon
extends BasicScreenAddon {
    private final SoulLaserBaseBlockEntity soulLaserBaseBlockEntity;
    private List<GuiParticle> particleList = new ArrayList<GuiParticle>();
    private long lastCheckedForParticle;

    public SculkSoulTankScreenAddon(int posX, int posY, SoulLaserBaseBlockEntity soulLaserBaseBlockEntity) {
        super(posX, posY);
        this.soulLaserBaseBlockEntity = soulLaserBaseBlockEntity;
        this.lastCheckedForParticle = Minecraft.getInstance().level.getGameTime();
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        int ageTick;
        double fullAmount = Math.min(1.0, (double)this.soulLaserBaseBlockEntity.getSoulAmount() / (double)ConfigSoulLaserBase.SOUL_STORAGE_AMOUNT);
        long currentTime = Minecraft.getInstance().level.getGameTime();
        if (this.lastCheckedForParticle != currentTime) {
            if (Minecraft.getInstance().level.random.nextDouble() <= fullAmount) {
                this.particleList.add(new GuiParticle(this, Minecraft.getInstance().level.random.nextInt(this.getXSize() - 14), this.getYSize() - 17 - Minecraft.getInstance().level.random.nextInt(10), currentTime));
            }
            this.lastCheckedForParticle = currentTime;
        }
        if (currentTime % (long)(ageTick = 3) == 0L) {
            this.particleList.removeIf(guiParticle -> (currentTime - guiParticle.age) / (long)ageTick > 10L);
        }
        for (GuiParticle guiParticle2 : this.particleList) {
            double particleAge = (double)(currentTime - guiParticle2.age) / (double)ageTick;
            double extraY = -((double)(this.getYSize() - 32) / 10.0) * particleAge;
            guiGraphics.blit(ResourceLocation.withDefaultNamespace((String)("textures/particle/sculk_soul_" + Math.max(0, Math.min(10, (int)particleAge)) + ".png")), this.getPosX() + guiX + guiParticle2.x, (int)((double)(this.getPosY() + guiY + guiParticle2.y) + extraY), 0.0f, 0.0f, 16, 16, 16, 16);
        }
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoingsouls", (String)"textures/gui/soul_tank.png"), this.getPosX() + guiX, this.getPosY() + guiY, 0.0f, 0.0f, 65, 60, 65, 60);
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        double fullAmount = Math.min(1.0, (double)this.soulLaserBaseBlockEntity.getSoulAmount() / (double)ConfigSoulLaserBase.SOUL_STORAGE_AMOUNT);
        if (this.isMouseOver(mouseX - guiX, mouseY - guiY)) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)"industrialforegoingsouls.soul_storage").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)(String.valueOf(ChatFormatting.WHITE) + new DecimalFormat("##.##").format(fullAmount * 100.0))).append("%").withStyle(ChatFormatting.YELLOW)), mouseX - guiX, mouseY - guiY);
        }
    }

    public int getXSize() {
        return 65;
    }

    public int getYSize() {
        return 60;
    }

    private class GuiParticle {
        private int x;
        private int y;
        private long age;

        public GuiParticle(SculkSoulTankScreenAddon sculkSoulTankScreenAddon, int x, int y, long age) {
            this.x = x;
            this.y = y;
            this.age = age;
        }
    }
}

