/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.jade;

import com.arcaryx.cobblemonintegrations.util.MiscUtilsKt;
import com.arcaryx.cobblemonintegrations.util.TextUtilsKt;
import com.cobblemon.mod.common.api.berry.Berry;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.block.entity.BerryBlockEntity;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0005H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/arcaryx/cobblemonintegrations/jade/BerryProvider;", "Lsnownee/jade/api/IBlockComponentProvider;", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "getUid", "appendTooltip", "", "tooltip", "Lsnownee/jade/api/ITooltip;", "accessor", "Lsnownee/jade/api/BlockAccessor;", "config", "Lsnownee/jade/api/config/IPluginConfig;", "addMaturityTooltip", "growthValue", "", "addBerryTooltip", "treeEntity", "Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;", "cobblemonintegrations-common-1.21.1"})
public final class BerryProvider
implements IBlockComponentProvider {
    @NotNull
    public static final BerryProvider INSTANCE = new BerryProvider();
    @NotNull
    private static final ResourceLocation ID;

    private BerryProvider() {
    }

    @NotNull
    public final ResourceLocation getID() {
        return ID;
    }

    @NotNull
    public ResourceLocation getUid() {
        return ID;
    }

    public void appendTooltip(@NotNull ITooltip tooltip, @NotNull BlockAccessor accessor, @NotNull IPluginConfig config) {
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        BlockState state = accessor.getBlockState();
        Block block = state.getBlock();
        if (!(block instanceof BerryBlock)) {
            return;
        }
        tooltip.remove(JadeIds.MC_CROP_PROGRESS);
        this.addMaturityTooltip(tooltip, (float)((Number)((Object)state.getValue((Property)BerryBlock.Companion.getAGE()))).intValue() / (float)5);
        BlockEntity blockEntity = accessor.getBlockEntity();
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.entity.BerryBlockEntity");
        this.addBerryTooltip(tooltip, (BerryBlockEntity)blockEntity);
    }

    private final void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        float adjustedGrowthValue = growthValue * 100.0f;
        if (adjustedGrowthValue < 100.0f) {
            Object[] objectArray = new Object[1];
            String string = "%.0f%%";
            Object[] objectArray2 = new Object[]{Float.valueOf(adjustedGrowthValue)};
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            MutableComponent mutableComponent = Component.literal((String)string2);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            objectArray[0] = TextKt.white((MutableComponent)mutableComponent);
            tooltip.add((Component)Component.translatable((String)"tooltip.jade.crop_growth", (Object[])objectArray));
        } else {
            Object[] objectArray = new Object[1];
            MutableComponent mutableComponent = Component.translatable((String)"tooltip.jade.crop_mature");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            objectArray[0] = TextKt.green((MutableComponent)mutableComponent);
            tooltip.add((Component)Component.translatable((String)"tooltip.jade.crop_growth", (Object[])objectArray));
        }
    }

    private final void addBerryTooltip(ITooltip tooltip, BerryBlockEntity treeEntity) {
        Berry berry = treeEntity.berry();
        if (berry != null) {
            String berryTooltip = TextUtilsKt.translateText("item.cobblemon." + berry.getIdentifier().getPath() + ".tooltip", new Object[0]);
            List<String> berryLines = TextUtilsKt.wrapString(berryTooltip, 32);
            for (String line : berryLines) {
                tooltip.add((Component)Component.literal((String)line));
            }
        }
    }

    static {
        ResourceLocation resourceLocation = MiscUtilsKt.modResource("berry_bush");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"modResource(...)");
        ID = resourceLocation;
    }
}

