/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.sereneseasons;

import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.pokemon.feature.CobblemonSeason;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"Lcom/arcaryx/cobblemonintegrations/sereneseasons/SereneSeasonsHandler;", "", "<init>", "()V", "isCurrentSeasonInAllowed", "", "level", "Lnet/minecraft/world/level/Level;", "allowedSeasons", "", "", "getSeasonListComponent", "Lnet/minecraft/network/chat/MutableComponent;", "getCurrentSeasonAsCobblemonSeason", "Lcom/cobblemon/mod/common/pokemon/feature/CobblemonSeason;", "cobblemonintegrations-common-1.21.1"})
public final class SereneSeasonsHandler {
    @NotNull
    public static final SereneSeasonsHandler INSTANCE = new SereneSeasonsHandler();

    private SereneSeasonsHandler() {
    }

    public final boolean isCurrentSeasonInAllowed(@NotNull Level level, @NotNull List<String> allowedSeasons) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(allowedSeasons, (String)"allowedSeasons");
        ISeasonState state = SeasonHelper.getSeasonState((Level)level);
        return allowedSeasons.contains(state.getSeason().name()) || allowedSeasons.contains(state.getSubSeason().name());
    }

    @NotNull
    public final MutableComponent getSeasonListComponent(@NotNull List<String> allowedSeasons) {
        Intrinsics.checkNotNullParameter(allowedSeasons, (String)"allowedSeasons");
        MutableComponent component = Component.empty();
        MutableComponent mutableComponent = ((Iterable)allowedSeasons).iterator();
        int n = 0;
        while (mutableComponent.hasNext()) {
            int index = n++;
            String season = (String)mutableComponent.next();
            MutableComponent mutableComponent2 = component;
            Intrinsics.checkNotNull((Object)mutableComponent2);
            String string = season.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            MutableComponent mutableComponent3 = Component.translatable((String)("desc.sereneseasons." + string));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
            TextKt.add((MutableComponent)mutableComponent2, (Component)((Component)mutableComponent3));
            if (index == allowedSeasons.size() - 1) continue;
            mutableComponent2 = component;
            Intrinsics.checkNotNull((Object)mutableComponent2);
            MutableComponent mutableComponent4 = Component.literal((String)", ");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"literal(...)");
            TextKt.add((MutableComponent)mutableComponent2, (Component)((Component)mutableComponent4));
        }
        mutableComponent = component;
        Intrinsics.checkNotNull((Object)mutableComponent);
        return mutableComponent;
    }

    @NotNull
    public final CobblemonSeason getCurrentSeasonAsCobblemonSeason(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ISeasonState state = SeasonHelper.getSeasonState((Level)level);
        return CobblemonSeason.valueOf((String)state.getSeason().name());
    }
}

