/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.toughasnails;

import com.arcaryx.cobblemonintegrations.config.CobblemonIntegrationsConfig;
import com.arcaryx.cobblemonintegrations.toughasnails.PokemonTemperatureModifier;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.cobblemon.mod.common.platform.events.ServerEvent;
import com.cobblemon.mod.common.pokemon.Pokemon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import toughasnails.api.item.TANItems;
import toughasnails.api.temperature.IPlayerTemperatureModifier;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.thirst.WaterType;
import toughasnails.item.EmptyCanteenItem;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ(\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/arcaryx/cobblemonintegrations/toughasnails/ToughAsNailsHandler;", "", "<init>", "()V", "init", "", "interactPokemon", "Lnet/minecraft/world/item/ItemStack;", "target", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "fillItem", "stack", "filledStack", "cobblemonintegrations-common-1.21.1"})
public final class ToughAsNailsHandler {
    @NotNull
    public static final ToughAsNailsHandler INSTANCE = new ToughAsNailsHandler();

    private ToughAsNailsHandler() {
    }

    public final void init() {
        Observable.DefaultImpls.subscribe$default((Observable)((Observable)PlatformEvents.SERVER_STARTING), null, ToughAsNailsHandler::init$lambda$0, (int)1, null);
    }

    @Nullable
    public final ItemStack interactPokemon(@NotNull PokemonEntity target, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Pokemon pokemon = target.getPokemon();
        if (((Boolean)CobblemonIntegrationsConfig.INSTANCE.getPOKEMON_GIVE_WATER().get()).booleanValue() && Intrinsics.areEqual((Object)target.getOwnerUUID(), (Object)player.getUUID()) && (Intrinsics.areEqual((Object)pokemon.getPrimaryType(), (Object)ElementalTypes.INSTANCE.getWATER()) || !((Boolean)CobblemonIntegrationsConfig.INSTANCE.getREQUIRE_PRIMARY_TYPE().get()).booleanValue() && Intrinsics.areEqual((Object)pokemon.getSecondaryType(), (Object)ElementalTypes.INSTANCE.getWATER()))) {
            ItemStack stack = player.getItemInHand(hand);
            int level = pokemon.getLevel();
            WaterType water = null;
            Object object = level >= ((Number)CobblemonIntegrationsConfig.INSTANCE.getMIN_LEVEL_FOR_PURIFIED().get()).intValue() ? WaterType.PURIFIED : (level >= ((Number)CobblemonIntegrationsConfig.INSTANCE.getMIN_LEVEL_FOR_NORMAL().get()).intValue() ? WaterType.NORMAL : (water = level >= ((Number)CobblemonIntegrationsConfig.INSTANCE.getMIN_LEVEL_FOR_DIRTY().get()).intValue() ? WaterType.DIRTY : null));
            if (((Boolean)CobblemonIntegrationsConfig.INSTANCE.getFILL_BOTTLE().get()).booleanValue() && water != null && stack.is(Items.GLASS_BOTTLE)) {
                player.playSound(SoundEvents.BOTTLE_FILL, 1.0f, 1.0f);
                WaterType waterType = water;
                ItemStack filledStack = switch (WhenMappings.$EnumSwitchMapping$0[waterType.ordinal()]) {
                    case 1 -> TANItems.PURIFIED_WATER_BOTTLE.getDefaultInstance();
                    case 2 -> TANItems.DIRTY_WATER_BOTTLE.getDefaultInstance();
                    default -> PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
                };
                Intrinsics.checkNotNull((Object)stack);
                Intrinsics.checkNotNull((Object)filledStack);
                return this.fillItem(player, stack, filledStack, hand);
            }
            if (((Boolean)CobblemonIntegrationsConfig.INSTANCE.getFILL_CANTEEN().get()).booleanValue() && water != null && stack.getItem() instanceof EmptyCanteenItem) {
                Item item = stack.getItem();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type toughasnails.item.EmptyCanteenItem");
                EmptyCanteenItem canteen = (EmptyCanteenItem)item;
                player.playSound(SoundEvents.BOTTLE_FILL, 1.0f, 1.0f);
                WaterType waterType = water;
                ItemStack filledStack = switch (WhenMappings.$EnumSwitchMapping$0[waterType.ordinal()]) {
                    case 1 -> canteen.getPurifiedWaterCanteen().getDefaultInstance();
                    case 2 -> canteen.getDirtyWaterCanteen().getDefaultInstance();
                    default -> canteen.getWaterCanteen().getDefaultInstance();
                };
                Intrinsics.checkNotNull((Object)stack);
                Intrinsics.checkNotNull((Object)filledStack);
                return this.fillItem(player, stack, filledStack, hand);
            }
        }
        return null;
    }

    private final ItemStack fillItem(Player player, ItemStack stack, ItemStack filledStack, InteractionHand hand) {
        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        EnchantmentHelper.setEnchantments((ItemStack)filledStack, (ItemEnchantments)EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack));
        ItemStack result = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)filledStack);
        player.setItemInHand(hand, result);
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    private static final Unit init$lambda$0(ServerEvent.Starting it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TemperatureHelper.registerPlayerTemperatureModifier((IPlayerTemperatureModifier)PokemonTemperatureModifier.INSTANCE);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WaterType.values().length];
            try {
                nArray[WaterType.PURIFIED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WaterType.DIRTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

