/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.client.gui.overlay;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.math.QuaternionUtilsKt;
import com.metacontent.cobblenav.client.CobblenavClient;
import com.metacontent.cobblenav.client.gui.util.RenderUtilsKt;
import com.metacontent.cobblenav.client.settings.PokefinderSettings;
import com.metacontent.cobblenav.item.Pokefinder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001f\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ7\u0010\u0015\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0019\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lcom/metacontent/cobblenav/client/gui/overlay/PokefinderOverlay;", "Lnet/minecraft/client/gui/Gui;", "<init>", "()V", "", "initialize", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "Lnet/minecraft/client/DeltaTracker;", "deltaTracker", "render", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "", "rotation", "", "x", "y", "", "scale", "renderCompass", "(Lcom/mojang/blaze3d/vertex/PoseStack;FIID)V", "Lnet/minecraft/client/Minecraft;", "kotlin.jvm.PlatformType", "minecraft", "Lnet/minecraft/client/Minecraft;", "", "initialized", "Z", "offset", "I", "Companion", "cobblenav-common"})
@SourceDebugExtension(value={"SMAP\nPokefinderOverlay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokefinderOverlay.kt\ncom/metacontent/cobblenav/client/gui/overlay/PokefinderOverlay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1863#2,2:129\n*S KotlinDebug\n*F\n+ 1 PokefinderOverlay.kt\ncom/metacontent/cobblenav/client/gui/overlay/PokefinderOverlay\n*L\n81#1:129,2\n*E\n"})
public final class PokefinderOverlay
extends Gui {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Minecraft minecraft = Minecraft.getInstance();
    private boolean initialized;
    private final int offset = CobblenavClient.INSTANCE.getConfig().getPokefinderOverlayOffset();
    public static final int WIDTH = 144;
    public static final int HEIGHT = 96;
    public static final int COMPASS_WIDTH = 23;
    public static final int COMPASS_HEIGHT = 23;
    public static final int COMPASS_OFFSET = 4;
    public static final double RADAR_SCALE = 0.5;
    @NotNull
    private static final ResourceLocation BACKGROUND = RenderUtilsKt.gui("pokefinder/overlay");
    @NotNull
    private static final ResourceLocation COMPASS = RenderUtilsKt.gui("pokefinder/compass");

    public PokefinderOverlay() {
        super(Minecraft.getInstance());
    }

    public final void initialize() {
        this.initialized = true;
    }

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        Object object;
        LocalPlayer player;
        PoseStack poseStack;
        int y;
        int x;
        int scaledHeight;
        int scaledWidth;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
                Intrinsics.checkNotNullParameter((Object)deltaTracker, (String)"deltaTracker");
                if (!this.initialized) {
                    return;
                }
                PokefinderSettings settings = CobblenavClient.INSTANCE.getPokefinderSettings();
                LocalPlayer localPlayer = this.minecraft.player;
                boolean isRightHand = (localPlayer != null && (localPlayer = localPlayer.getMainHandItem()) != null ? localPlayer.getItem() : null) instanceof Pokefinder;
                double scale = (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth() * this.minecraft.getWindow().getGuiScale();
                int scaledOffset = (int)((double)this.offset / scale);
                scaledWidth = (int)((double)144 / scale);
                scaledHeight = (int)((double)96 / scale);
                x = isRightHand ? this.minecraft.getWindow().getGuiScaledWidth() - scaledWidth - scaledOffset : scaledOffset;
                y = this.minecraft.getWindow().getGuiScaledHeight() - scaledHeight - scaledOffset;
                poseStack = guiGraphics.pose();
                Intrinsics.checkNotNull((Object)poseStack);
                PoseStack poseStack2 = poseStack;
                ResourceLocation resourceLocation = BACKGROUND;
                GuiUtilsKt.blitk$default((PoseStack)poseStack2, (ResourceLocation)resourceLocation, (Number)x, (Number)y, (Number)scaledHeight, (Number)scaledWidth, null, null, null, null, null, null, null, null, null, (boolean)false, (float)0.0f, (int)131008, null);
                LocalPlayer localPlayer2 = this.minecraft.player;
                if (localPlayer2 == null) {
                    return;
                }
                player = localPlayer2;
                this.renderCompass(poseStack, 180.0f - player.getRotationVector().y, x, y, scale);
                double radius = 200.0;
                object = settings;
                if (object == null) break block6;
                PokefinderSettings it = object;
                boolean bl = false;
                ClientLevel clientLevel = this.minecraft.level;
                List list = clientLevel != null ? clientLevel.getEntitiesOfClass(PokemonEntity.class, AABB.ofSize((Vec3)player.position(), (double)radius, (double)radius, (double)radius), arg_0 -> PokefinderOverlay.render$lambda$2$lambda$1(arg_0 -> PokefinderOverlay.render$lambda$2$lambda$0(settings, arg_0), arg_0)) : null;
                object = list;
                if (list != null) break block7;
            }
            object = CollectionsKt.emptyList();
        }
        Object entities = object;
        Iterable $this$forEach$iv = (Iterable)entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PokemonEntity it = (PokemonEntity)element$iv;
            boolean bl = false;
            Vec3 vec = player.position().vectorTo(it.position()).scale(0.5);
            double angle = Math.toRadians(180.0 - (double)player.getRotationVector().y);
            double posX = (double)(x + scaledWidth / 2) + 0.5 + vec.x * Math.cos(angle) - vec.z * Math.sin(angle);
            double posY = (double)(y + scaledHeight / 2) + 0.5 + vec.x * Math.sin(angle) + vec.z * Math.cos(angle);
            RenderUtilsKt.pushAndPop$default(poseStack, new Vector3d(posX, posY, 0.0), null, null, () -> PokefinderOverlay.render$lambda$4$lambda$3(guiGraphics, it), 6, null);
        }
    }

    private final void renderCompass(PoseStack poseStack, float rotation, int x, int y, double scale) {
        int compassWidth = (int)((double)23 / scale);
        int compassHeight = (int)((double)23 / scale);
        int compassOffset = (int)((double)4 / scale);
        RenderUtilsKt.pushAndPop$default(poseStack, null, null, null, () -> PokefinderOverlay.renderCompass$lambda$5(poseStack, rotation, x, compassOffset, compassWidth, y, compassHeight), 7, null);
    }

    private static final boolean render$lambda$2$lambda$0(PokefinderSettings $settings, PokemonEntity it) {
        return $settings.check(it.getPokemon());
    }

    private static final boolean render$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit render$lambda$4$lambda$3(GuiGraphics $guiGraphics, PokemonEntity $it) {
        $guiGraphics.fill(-1, -1, 1, 1, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        MutableComponent mutableComponent = $it.getPokemon().getDisplayName();
        RenderHelperKt.drawScaledText$default((GuiGraphics)$guiGraphics, null, (MutableComponent)mutableComponent, (Number)0, (Number)2, (float)0.4f, null, (int)0, (int)0, (boolean)true, (boolean)false, null, null, (int)7618, null);
        return Unit.INSTANCE;
    }

    private static final Unit renderCompass$lambda$5(PoseStack $poseStack, float $rotation, int $x, int $compassOffset, int $compassWidth, int $y, int $compassHeight) {
        $poseStack.rotateAround(QuaternionUtilsKt.fromEulerXYZDegrees((Quaternionf)new Quaternionf(), (Vector3f)new Vector3f(0.0f, 0.0f, $rotation)), (float)($x + $compassOffset) + (float)$compassWidth / 2.0f, (float)($y + $compassOffset) + (float)$compassHeight / 2.0f, 0.0f);
        ResourceLocation resourceLocation = COMPASS;
        int n = $x + $compassOffset;
        int n2 = $y + $compassOffset;
        GuiUtilsKt.blitk$default((PoseStack)$poseStack, (ResourceLocation)resourceLocation, (Number)n, (Number)n2, (Number)$compassHeight, (Number)$compassWidth, null, null, null, null, null, null, null, null, null, (boolean)false, (float)0.0f, (int)131008, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0017\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/metacontent/cobblenav/client/gui/overlay/PokefinderOverlay$Companion;", "", "<init>", "()V", "", "WIDTH", "I", "HEIGHT", "COMPASS_WIDTH", "COMPASS_HEIGHT", "COMPASS_OFFSET", "", "RADAR_SCALE", "D", "Lnet/minecraft/resources/ResourceLocation;", "BACKGROUND", "Lnet/minecraft/resources/ResourceLocation;", "getBACKGROUND", "()Lnet/minecraft/resources/ResourceLocation;", "COMPASS", "getCOMPASS", "cobblenav-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getBACKGROUND() {
            return BACKGROUND;
        }

        @NotNull
        public final ResourceLocation getCOMPASS() {
            return COMPASS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

