/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.module.config.loader;

import dev.architectury.platform.Platform;
import it.hurts.octostudios.octolib.module.config.cfgbuilder.ArrayEntry;
import it.hurts.octostudios.octolib.module.config.cfgbuilder.ConfigEntry;
import it.hurts.octostudios.octolib.module.config.loader.IConfigFileLoader;
import it.hurts.octostudios.octolib.module.config.provider.ConfigProvider;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class FileSpreadLoader<T>
implements IConfigFileLoader<Iterable<T>, List<T>> {
    @Override
    public void saveToFiles(String filePath, Iterable<T> data, ConfigProvider provider) {
        File file = Platform.getConfigFolder().resolve(filePath + ".yaml").toFile();
        if (file.getParentFile().isDirectory() || file.getParentFile().mkdirs()) {
            try (FileWriter writer = new FileWriter(file);){
                provider.saveAll(writer, data.iterator());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<T> loadFiles(String filePath, ConfigEntry pattern, ConfigProvider provider) {
        File file = Platform.getConfigFolder().resolve(filePath + ".yaml").toFile();
        if (file.isFile()) {
            List list;
            FileReader writer = new FileReader(file);
            try {
                list = provider.loadAll(writer, ((ArrayEntry)pattern).iterator());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            writer.close();
            return list;
        }
        return null;
    }
}

