/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.imageselect;

import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.widgets.ColoredImageWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ImageSlot
extends ColoredImageWidget.Image
implements Comparable<ImageSlot> {
    private ResourceLocation image;

    protected ImageSlot(ResourceLocation image, int width, int height, int color) {
        super(0, 0, width, height, TextureCache.waypointIconMap.get(image), width, height, color, false);
        this.image = image;
        this.setTooltip(Tooltip.create((Component)Component.literal((String)this.image.toString())));
    }

    public ResourceLocation getImage() {
        return this.image;
    }

    public String fileName() {
        String[] pathParts = this.image.getPath().split("/");
        return pathParts[pathParts.length - 1];
    }

    @Override
    public int compareTo(@NotNull ImageSlot o) {
        return this.image.compareTo(o.image);
    }

    @Override
    protected void drawOutline(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        DrawUtil.drawRectangle(graphics, this.getX() - 2, this.getY() - 2, this.getWidth() + 4, this.getHeight() + 4, 0xC0C0C0, 0.7f);
        DrawUtil.drawRectangle(graphics, this.getX() - 1, this.getY() - 1, this.getWidth() + 2, this.getHeight() + 2, 0x404040, 0.9f);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void setImage(ResourceLocation image) {
        this.image = image;
        super.setTexture(TextureCache.waypointIconMap.get(image));
    }
}

