/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.systems.gear;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.WeightedItemStack;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import dev.shadowsoffire.placebo.systems.gear.GearSetRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public record GearSet(int weight, float quality, List<WeightedItemStack> mainhands, List<WeightedItemStack> offhands, List<WeightedItemStack> boots, List<WeightedItemStack> leggings, List<WeightedItemStack> chestplates, List<WeightedItemStack> helmets, Set<String> tags) implements CodecProvider<GearSet>,
WeightedDynamicRegistry.ILuckyWeighted
{
    public static EquipmentSlot[] VALID_SLOTS = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND, EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    public static final Codec<GearSet> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedDynamicRegistry.ILuckyWeighted::getWeight), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedDynamicRegistry.ILuckyWeighted::getQuality), (App)WeightedItemStack.LIST_CODEC.optionalFieldOf("mainhands", Collections.emptyList()).forGetter(GearSet::mainhands), (App)WeightedItemStack.LIST_CODEC.optionalFieldOf("offhands", Collections.emptyList()).forGetter(GearSet::offhands), (App)WeightedItemStack.LIST_CODEC.optionalFieldOf("boots", Collections.emptyList()).forGetter(GearSet::boots), (App)WeightedItemStack.LIST_CODEC.optionalFieldOf("leggings", Collections.emptyList()).forGetter(GearSet::leggings), (App)WeightedItemStack.LIST_CODEC.optionalFieldOf("chestplates", Collections.emptyList()).forGetter(GearSet::chestplates), (App)WeightedItemStack.LIST_CODEC.optionalFieldOf("helmets", Collections.emptyList()).forGetter(GearSet::helmets), (App)PlaceboCodecs.setOf(Codec.STRING).fieldOf("tags").forGetter(GearSet::tags)).apply((Applicative)inst, GearSet::new));

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public float getQuality() {
        return this.quality;
    }

    public LivingEntity apply(LivingEntity entity) {
        for (EquipmentSlot slot : VALID_SLOTS) {
            WeightedRandom.getRandomItem((RandomSource)entity.getRandom(), this.getPotentials(slot)).ifPresent(s -> s.apply(entity, slot));
        }
        return entity;
    }

    public List<WeightedItemStack> getPotentials(EquipmentSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.MAINHAND -> this.mainhands;
            case EquipmentSlot.OFFHAND -> this.offhands;
            case EquipmentSlot.FEET -> this.boots;
            case EquipmentSlot.LEGS -> this.leggings;
            case EquipmentSlot.CHEST -> this.chestplates;
            case EquipmentSlot.HEAD -> this.helmets;
            case EquipmentSlot.BODY -> throw new UnsupportedOperationException("Invalid slot type: " + String.valueOf(slot));
        };
    }

    @Override
    public Codec<? extends GearSet> getCodec() {
        return CODEC;
    }

    public static class SetPredicate
    implements Predicate<GearSet> {
        public static final Codec<SetPredicate> CODEC = Codec.stringResolver(s -> s.key, SetPredicate::new);
        protected final String key;
        protected final Predicate<GearSet> internal;

        public SetPredicate(String key) {
            this.key = key;
            if (key.startsWith("#")) {
                String tag = key.substring(1);
                this.internal = t -> t.tags.contains(tag);
            } else {
                ResourceLocation id = ResourceLocation.parse((String)key);
                this.internal = t -> GearSetRegistry.INSTANCE.getKey(t).equals((Object)id);
            }
        }

        @Override
        public boolean test(GearSet t) {
            return this.internal.test(t);
        }

        public String toString() {
            return "SetPredicate[" + this.key + "]";
        }
    }
}

