/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.ClientProxy;
import com.bobmowzie.mowziesmobs.client.gui.CustomBossBar;
import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerFirstPerson;
import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerThirdPerson;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoFirstPersonRenderer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoRenderPlayer;
import com.bobmowzie.mowziesmobs.client.sound.BossMusicPlayer;
import com.bobmowzie.mowziesmobs.server.capability.AbilityData;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.capability.FrozenData;
import com.bobmowzie.mowziesmobs.server.capability.PlayerData;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrozenController;
import com.bobmowzie.mowziesmobs.server.item.ItemBlowgun;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEventHandler {
    private static final ResourceLocation FROZEN_BLUR = ResourceLocation.withDefaultNamespace((String)"textures/misc/powder_snow_outline.png");
    private static ResourceLocation SCULPTOR_BLOCK_GLOW = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/entity/sculptor_highlight.png");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onHandRender(RenderHandEvent event) {
        GeckoPlayer.GeckoPlayerFirstPerson geckoPlayer;
        if (!((Boolean)ConfigHandler.CLIENT.customPlayerAnims.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        boolean shouldAnimate = false;
        AbilityData data = DataHandler.getData((Entity)player, DataHandler.ABILITY_DATA);
        boolean bl = shouldAnimate = data.getActiveAbility() != null;
        if (shouldAnimate && (geckoPlayer = GeckoFirstPersonRenderer.GECKO_PLAYER_FIRST_PERSON) != null) {
            ModelGeckoPlayerFirstPerson geckoFirstPersonModel = (ModelGeckoPlayerFirstPerson)geckoPlayer.getModel();
            GeckoFirstPersonRenderer firstPersonRenderer = (GeckoFirstPersonRenderer)geckoPlayer.getPlayerRenderer();
            if (geckoFirstPersonModel != null && firstPersonRenderer != null) {
                if (!geckoFirstPersonModel.isUsingSmallArms() && player.getSkin().model().name().equals("slim")) {
                    firstPersonRenderer.setSmallArms();
                }
                event.setCanceled(true);
                if (event.isCanceled()) {
                    float delta = event.getPartialTick();
                    float f1 = Mth.lerp((float)delta, (float)player.xRotO, (float)player.getXRot());
                    firstPersonRenderer.renderItemInFirstPerson((AbstractClientPlayer)player, f1, delta, event.getHand(), event.getSwingProgress(), event.getItemStack(), event.getEquipProgress(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), geckoPlayer);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void renderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer;
            Player player = (Player)livingEntity;
            if (!((Boolean)ConfigHandler.CLIENT.customPlayerAnims.get()).booleanValue()) {
                return;
            }
            if (((Boolean)ConfigHandler.CLIENT.hidePlayerAnimsInFirstPerson.get()).booleanValue() && player == Minecraft.getInstance().player && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
                return;
            }
            float delta = event.getPartialTick();
            AbilityData abilityData = DataHandler.getData((Entity)player, DataHandler.ABILITY_DATA);
            if (abilityData.getActiveAbility() != null && (geckoPlayer = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA).getGeckoPlayer()) != null) {
                ModelGeckoPlayerThirdPerson geckoPlayerModel = (ModelGeckoPlayerThirdPerson)geckoPlayer.getModel();
                GeckoRenderPlayer animatedPlayerRenderer = (GeckoRenderPlayer)geckoPlayer.getPlayerRenderer();
                if (geckoPlayerModel != null && animatedPlayerRenderer != null) {
                    event.setCanceled(true);
                    if (event.isCanceled()) {
                        animatedPlayerRenderer.render((AbstractClientPlayer)event.getEntity(), event.getEntity().getYRot(), delta, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), geckoPlayer);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA).getGeckoPlayer();
            if (geckoPlayer != null) {
                geckoPlayer.tick();
            }
            if (player == Minecraft.getInstance().player) {
                GeckoFirstPersonRenderer.GECKO_PLAYER_FIRST_PERSON.tick();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderTick(RenderFrameEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        FrozenData data = DataHandler.getData((Entity)player, DataHandler.FROZEN_DATA);
        if (data.getFrozen() && data.getPrevFrozen()) {
            player.setYRot(data.getFrozenYaw());
            player.setXRot(data.getFrozenPitch());
            player.yHeadRot = data.getFrozenYawHead();
            player.yRotO = player.getYRot();
            player.xRotO = player.getXRot();
            player.yHeadRotO = player.yHeadRot;
        }
    }

    @SubscribeEvent
    public static void onRenderLiving(RenderLivingEvent.Pre<?, ?> event) {
        LivingEntity entity = event.getEntity();
        FrozenData data = DataHandler.getData((Entity)entity, DataHandler.FROZEN_DATA);
        if (data.getFrozen() && data.getPrevFrozen()) {
            entity.yRotO = data.getFrozenYaw();
            entity.setYRot(entity.yRotO);
            entity.xRotO = data.getFrozenPitch();
            entity.setXRot(entity.xRotO);
            entity.yHeadRot = entity.yHeadRotO = data.getFrozenYawHead();
            entity.yBodyRot = entity.yBodyRotO = data.getFrozenRenderYawOffset();
            entity.attackAnim = entity.oAttackAnim = data.getFrozenSwingProgress();
            entity.walkAnimation.setSpeed(0.0f);
            entity.walkAnimation.update(0.0f, 0.0f);
            entity.setShiftKeyDown(false);
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiLayerEvent.Post event) {
        FrozenData data;
        if (event.getName() == VanillaGuiLayers.CAMERA_OVERLAYS && Minecraft.getInstance().player != null && (data = DataHandler.getData((Entity)Minecraft.getInstance().player, DataHandler.FROZEN_DATA)).getFrozen() && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
            GuiGraphics graphics = event.getGuiGraphics();
            graphics.blit(FROZEN_BLUR, 0, 0, 0.0f, 0.0f, graphics.guiWidth(), graphics.guiHeight(), graphics.guiWidth(), graphics.guiHeight());
        }
    }

    @SubscribeEvent
    public static void onRenderHUD(RenderGuiLayerEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isPassenger() && player.getVehicle() instanceof EntityFrozenController) {
            if (event.getName() == VanillaGuiLayers.VEHICLE_HEALTH) {
                event.setCanceled(true);
            }
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.empty(), false);
        }
    }

    @SubscribeEvent
    public static void updateFOV(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        if (player.isUsingItem() && player.getUseItem().getItem() instanceof ItemBlowgun) {
            int i = player.getTicksUsingItem();
            float f1 = (float)i / 5.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.setNewFovModifier(1.0f - f1 * 0.15f);
        }
    }

    @SubscribeEvent
    public static void onSetupCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.getInstance().player;
        float delta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        float ticksExistedDelta = (float)player.tickCount + delta;
        if (((Boolean)ConfigHandler.CLIENT.doCameraShakes.get()).booleanValue() && !Minecraft.getInstance().isPaused()) {
            float shakeAmplitude = 0.0f;
            for (EntityCameraShake cameraShake : player.level().getEntitiesOfClass(EntityCameraShake.class, player.getBoundingBox().inflate(20.0, 20.0, 20.0))) {
                if (!(cameraShake.distanceTo((Entity)player) < cameraShake.getRadius())) continue;
                shakeAmplitude += cameraShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
            event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
            event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (!((Boolean)ConfigHandler.CLIENT.customBossBars.get()).booleanValue()) {
            return;
        }
        ResourceLocation bossRegistryName = ClientProxy.bossBarRegistryNames.getOrDefault(event.getBossEvent().getId(), null);
        if (bossRegistryName == null) {
            return;
        }
        CustomBossBar customBossBar = CustomBossBar.customBossBars.getOrDefault(bossRegistryName, null);
        if (customBossBar == null) {
            return;
        }
        event.setCanceled(true);
        customBossBar.renderBossBar(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            ClientLevel level = Minecraft.getInstance().level;
            if (Minecraft.getInstance().player != null && level != null) {
                Vec3 cameraPos = event.getCamera().getPosition();
                double d0 = cameraPos.x();
                double d1 = cameraPos.y();
                double d2 = cameraPos.z();
                for (Long2ObjectMap.Entry entry : ClientProxy.sculptorMarkedBlocks.long2ObjectEntrySet()) {
                    BlockPos blockpos2 = BlockPos.of((long)entry.getLongKey());
                    event.getPoseStack().pushPose();
                    event.getPoseStack().translate((double)blockpos2.getX() - d0, (double)blockpos2.getY() - d1, (double)blockpos2.getZ() - d2);
                    PoseStack.Pose posestack$pose1 = event.getPoseStack().last();
                    float tick = event.getRenderTick();
                    float blockOffset = (float)(blockpos2.getX() + blockpos2.getY() + blockpos2.getZ()) * 0.25f;
                    SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(MMRenderType.highlight(SCULPTOR_BLOCK_GLOW, tick * 0.02f + blockOffset, tick * 0.01f + blockOffset)), posestack$pose1, 0.25f);
                    ModelData modelData = level.getModelDataManager().getAt(blockpos2);
                    ClientEventHandler.renderBreakingTexture(level.getBlockState(blockpos2), blockpos2, (BlockAndTintGetter)level, event.getPoseStack(), level.random, (VertexConsumer)vertexconsumer1, modelData);
                    event.getPoseStack().popPose();
                }
            }
        }
    }

    private static void renderBreakingTexture(BlockState state, BlockPos pos, BlockAndTintGetter blockAndTintGetter, PoseStack poseStack, RandomSource random, VertexConsumer vertexConsumer, ModelData modelData) {
        if (state.getRenderShape() == RenderShape.MODEL) {
            BlockRenderDispatcher blockRenderDispatcher = Minecraft.getInstance().getBlockRenderer();
            BakedModel bakedmodel = blockRenderDispatcher.getBlockModel(state);
            long i = state.getSeed(pos);
            blockRenderDispatcher.getModelRenderer().tesselateBlock(blockAndTintGetter, bakedmodel, state, pos, poseStack, vertexConsumer, true, random, i, OverlayTexture.NO_OVERLAY, modelData, null);
        }
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide()) {
            MMCommon.PROXY.updateMarkedBlocks();
            BossMusicPlayer.tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onInteractionKeyMappingTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        PlayerData data;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (event.getKeyMapping() == Minecraft.getInstance().options.keyAttack) {
            PlayerData data2 = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA);
            if (data2 != null) {
                data2.pressedAttackKey((Player)player);
            }
        } else if (event.getKeyMapping() == Minecraft.getInstance().options.keyUse && (data = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA)) != null) {
            data.pressedUseKey((Player)player);
        }
    }
}

