/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.render.entity.FrozenRenderHandler;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.SunblockLayer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

public class ClientLayerRegistry {
    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        ImmutableList entityTypes = ImmutableList.copyOf((Collection)MMCommon.getLivingEntityTypes().collect(Collectors.toList()));
        entityTypes.forEach(entityType -> ClientLayerRegistry.addLayerIfApplicable((EntityType<? extends LivingEntity>)entityType, event));
        for (PlayerSkin.Model skin : event.getSkins()) {
            EntityRenderer entityRenderer = event.getSkin(skin);
            if (!(entityRenderer instanceof LivingEntityRenderer)) continue;
            LivingEntityRenderer renderer = (LivingEntityRenderer)entityRenderer;
            renderer.addLayer(new FrozenRenderHandler.LayerFrozen(renderer));
            renderer.addLayer(new SunblockLayer(renderer));
        }
        GeckoPlayer.GeckoPlayerThirdPerson.initRenderer();
    }

    private static void addLayerIfApplicable(EntityType<? extends LivingEntity> entityType, EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer renderer = null;
        if (entityType != EntityType.ENDER_DRAGON) {
            block5: {
                try {
                    EntityRenderer entityRenderer = event.getRenderer(entityType);
                    if (entityRenderer instanceof LivingEntityRenderer) {
                        LivingEntityRenderer livingRenderer;
                        renderer = livingRenderer = (LivingEntityRenderer)entityRenderer;
                    }
                }
                catch (Exception e) {
                    if (entityType.getBaseClass().isAssignableFrom(MowzieEntity.class)) break block5;
                    MMCommon.LOGGER.warn("Could not apply layer to " + entityType.getDescriptionId() + ", has custom renderer that is not LivingEntityRenderer.");
                }
            }
            if (renderer != null) {
                renderer.addLayer(new FrozenRenderHandler.LayerFrozen(renderer));
                renderer.addLayer(new SunblockLayer(renderer));
            }
        }
    }
}

