/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleSnowFlake
extends TextureSheetParticle {
    private int swirlTick;
    private final float spread;
    boolean swirls;

    public ParticleSnowFlake(ClientLevel world, double x, double y, double z, double vX, double vY, double vZ, double duration, boolean swirls) {
        super(world, x, y, z);
        this.setSize(1.0f, 1.0f);
        this.xd = vX;
        this.yd = vY;
        this.zd = vZ;
        this.lifetime = (int)duration;
        this.swirlTick = this.random.nextInt(120);
        this.spread = this.random.nextFloat();
        this.swirls = swirls;
    }

    protected float getU1() {
        return super.getU1() - (super.getU1() - super.getU0()) / 8.0f;
    }

    protected float getV1() {
        return super.getV1() - (super.getV1() - super.getV0()) / 8.0f;
    }

    public ParticleRenderType getRenderType() {
        return MMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public void tick() {
        super.tick();
        if (this.swirls) {
            Vector3f motionVec = new Vector3f((float)this.xd, (float)this.yd, (float)this.zd);
            motionVec.normalize();
            float yaw = (float)Math.atan2(motionVec.x(), motionVec.z());
            float pitch = (float)Math.atan2(motionVec.y(), 1.0);
            float swirlRadius = 4.0f * ((float)this.age / (float)this.lifetime) * this.spread;
            Quaternionf quatSpin = new Quaternionf(new AxisAngle4f((float)this.swirlTick * 0.2f, (Vector3fc)motionVec));
            Quaternionf quatOrient = MathUtils.quatFromRotationXYZ(pitch, yaw, 0.0f, false);
            Vector3f vec = new Vector3f(swirlRadius, 0.0f, 0.0f);
            quatOrient.transform(vec);
            quatSpin.transform(vec);
            this.x += (double)vec.x();
            this.y += (double)vec.y();
            this.z += (double)vec.z();
        }
        if (this.age >= this.lifetime) {
            this.remove();
        }
        ++this.age;
        ++this.swirlTick;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float var = ((float)this.age + partialTicks) / (float)this.lifetime;
        this.alpha = (float)(1.0 - Math.exp(10.0f * (var - 1.0f)) - Math.pow(2000.0, -var));
        if ((double)this.alpha < 0.01) {
            this.alpha = 0.01f;
        }
        super.render(buffer, renderInfo, partialTicks);
    }

    public record Data(float duration, boolean swirls) implements ParticleOptions
    {
        public static final MapCodec<Data> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("duration").forGetter(Data::duration), (App)Codec.BOOL.fieldOf("swirls").forGetter(Data::swirls)).apply((Applicative)instance, Data::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, Data::duration, (StreamCodec)ByteBufCodecs.BOOL, Data::swirls, Data::new);

        @NotNull
        public ParticleType<Data> getType() {
            return (ParticleType)ParticleHandler.SNOWFLAKE.get();
        }
    }

    public static final class Provider
    implements ParticleProvider<Data> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(Data typeIn, @NotNull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSnowFlake particle = new ParticleSnowFlake(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.duration(), typeIn.swirls());
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

