/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelBoulder;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.BlockLayer;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderSculptor;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import org.joml.Quaternionf;

public class RenderBoulder
extends EntityRenderer<EntityBoulderBase> {
    private static final ResourceLocation TEXTURE_DIRT = ResourceLocation.withDefaultNamespace((String)"textures/block/dirt.png");
    private static final ResourceLocation TEXTURE_STONE = ResourceLocation.withDefaultNamespace((String)"textures/block/stone.png");
    private static final ResourceLocation TEXTURE_SANDSTONE = ResourceLocation.withDefaultNamespace((String)"textures/block/sandstone.png");
    private static final ResourceLocation TEXTURE_CLAY = ResourceLocation.withDefaultNamespace((String)"textures/block/clay.png");
    Map<String, ResourceLocation> texMap;
    ModelBoulder model = new ModelBoulder();

    public RenderBoulder(EntityRendererProvider.Context mgr) {
        super(mgr);
        this.texMap = new TreeMap<String, ResourceLocation>();
        this.texMap.put(Blocks.STONE.getDescriptionId(), TEXTURE_STONE);
        this.texMap.put(Blocks.DIRT.getDescriptionId(), TEXTURE_DIRT);
        this.texMap.put(Blocks.CLAY.getDescriptionId(), TEXTURE_CLAY);
        this.texMap.put(Blocks.SANDSTONE.getDescriptionId(), TEXTURE_SANDSTONE);
    }

    public ResourceLocation getTextureLocation(EntityBoulderBase entity) {
        ResourceLocation tex;
        if (entity.storedBlock != null && (tex = this.texMap.get(entity.storedBlock.getBlock().getDescriptionId())) != null) {
            return tex;
        }
        return TEXTURE_DIRT;
    }

    public void render(EntityBoulderBase entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (entityIn.isActive()) {
            EntityBoulderSculptor.EntityBoulderSculptorCrumbling crumbling;
            float frame = (float)entityIn.risingTick + partialTicks;
            matrixStackIn.pushPose();
            this.model.setupAnim(entityIn, 0.0f, 0.0f, frame, 0.0f, 0.0f);
            if (entityIn instanceof EntityBoulderSculptor.EntityBoulderSculptorCrumbling && (crumbling = (EntityBoulderSculptor.EntityBoulderSculptorCrumbling)entityIn).isCrumbling()) {
                matrixStackIn.mulPose(new Quaternionf().rotationXYZ(0.03f * (float)Math.cos(frame * 4.0f + 234.0f), 0.03f * (float)Math.cos(frame * 2.2f + 45.0f), 0.03f * (float)Math.cos(frame * 3.5f + 409.0f)));
            }
            BlockRenderDispatcher blockrendererdispatcher = Minecraft.getInstance().getBlockRenderer();
            AdvancedModelRenderer root = entityIn.boulderSize == EntityGeomancyBase.GeomancyTier.SMALL ? this.model.boulder0block1 : (entityIn.boulderSize == EntityGeomancyBase.GeomancyTier.MEDIUM ? this.model.boulder1 : (entityIn.boulderSize == EntityGeomancyBase.GeomancyTier.LARGE ? this.model.boulder2 : this.model.boulder3));
            matrixStackIn.translate(-0.5f, 0.5f, -0.5f);
            BlockLayer.processModelRenderer(root, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f, blockrendererdispatcher);
            matrixStackIn.popPose();
        }
    }
}

