/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity.layer;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.IGeckoRenderLayer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoRenderPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.capability.AbilityData;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class GeckoPlayerItemInHandLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>
implements IGeckoRenderLayer {
    private GeckoRenderPlayer renderPlayerAnimated;

    public GeckoPlayerItemInHandLayer(GeckoRenderPlayer entityRendererIn) {
        super((RenderLayerParent)entityRendererIn);
        this.renderPlayerAnimated = entityRendererIn;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack1;
        Ability<?> ability;
        if (!this.renderPlayerAnimated.getAnimatedPlayerModel().isInitialized()) {
            return;
        }
        boolean flag = entitylivingbaseIn.getMainArm() == HumanoidArm.RIGHT;
        ItemStack mainHandStack = entitylivingbaseIn.getMainHandItem();
        ItemStack offHandStack = entitylivingbaseIn.getOffhandItem();
        AbilityData abilityData = DataHandler.getData((Entity)entitylivingbaseIn, DataHandler.ABILITY_DATA);
        if (abilityData.getActiveAbility() != null && (ability = abilityData.getActiveAbility()) instanceof PlayerAbility) {
            PlayerAbility playerAbility = (PlayerAbility)ability;
            mainHandStack = playerAbility.heldItemMainHandOverride() != null ? playerAbility.heldItemMainHandOverride() : mainHandStack;
            offHandStack = playerAbility.heldItemOffHandOverride() != null ? playerAbility.heldItemOffHandOverride() : offHandStack;
        }
        ItemStack itemstack = flag ? offHandStack : mainHandStack;
        ItemStack itemStack = itemstack1 = flag ? mainHandStack : offHandStack;
        if (!itemstack.isEmpty() || !itemstack1.isEmpty()) {
            matrixStackIn.pushPose();
            if (((PlayerModel)this.getParentModel()).young) {
                float f = 0.5f;
                matrixStackIn.translate(0.0, 0.75, 0.0);
                matrixStackIn.scale(0.5f, 0.5f, 0.5f);
            }
            this.renderArmWithItem((LivingEntity)entitylivingbaseIn, itemstack1, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, matrixStackIn, bufferIn, packedLightIn);
            this.renderArmWithItem((LivingEntity)entitylivingbaseIn, itemstack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.popPose();
        }
    }

    private void renderArmWithItem(LivingEntity entity, ItemStack itemStack, ItemDisplayContext transformType, HumanoidArm side, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn) {
        if (!itemStack.isEmpty()) {
            String boneName = side == HumanoidArm.RIGHT ? "RightHeldItem" : "LeftHeldItem";
            MowzieGeoBone bone = this.renderPlayerAnimated.getAnimatedPlayerModel().getMowzieBone(boneName);
            PoseStack newMatrixStack = new PoseStack();
            newMatrixStack.last().normal().mul((Matrix3fc)bone.getWorldSpaceNormal());
            newMatrixStack.last().pose().mul((Matrix4fc)bone.getWorldSpaceMatrix());
            newMatrixStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            boolean flag = side == HumanoidArm.LEFT;
            Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderItem(entity, itemStack, transformType, flag, newMatrixStack, buffer, packedLightIn);
        }
    }
}

