/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity.layer;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoModel;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ClientHooks;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class UmvuthanaArmorLayer
extends GeoRenderLayer<EntityUmvuthana> {
    private final HumanoidModel defaultBipedModel;
    private final String boneName;

    public UmvuthanaArmorLayer(GeoRenderer<EntityUmvuthana> entityRendererIn, EntityRendererProvider.Context context, String boneName) {
        super(entityRendererIn);
        this.defaultBipedModel = new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR));
        this.boneName = boneName;
    }

    public void render(PoseStack poseStack, EntityUmvuthana animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        super.render(poseStack, (GeoAnimatable)animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        MowzieGeoModel model = (MowzieGeoModel)this.getGeoModel();
        MowzieGeoBone mask = model.getMowzieBone(this.boneName);
        if (!mask.isHidden()) {
            poseStack.pushPose();
            poseStack.setIdentity();
            poseStack.mulPose(mask.getPose());
            this.renderArmor((LivingEntity)animatable, bufferSource, poseStack, packedLight);
            bufferSource.getBuffer(renderType);
            poseStack.popPose();
        }
    }

    private void renderArmor(LivingEntity entityLivingBaseIn, MultiBufferSource bufferIn, PoseStack poseStack, int packedLightIn) {
        ArmorItem armoritem;
        ItemStack itemStack = entityLivingBaseIn.getItemBySlot(EquipmentSlot.HEAD);
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem && (armoritem = (ArmorItem)item).getType() == ArmorItem.Type.HELMET) {
            boolean glintIn = itemStack.hasFoil();
            HumanoidModel<?> model = this.getArmorModelHook(entityLivingBaseIn, itemStack, EquipmentSlot.HEAD, this.defaultBipedModel);
            ((ArmorMaterial)armoritem.getMaterial().value()).layers().forEach(layer -> {
                ResourceLocation armorTexture = armoritem.getArmorTexture(itemStack, (Entity)entityLivingBaseIn, EquipmentSlot.HEAD, layer, false);
                if (armorTexture != null) {
                    VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)armorTexture), (boolean)false, (boolean)glintIn);
                    poseStack.pushPose();
                    poseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)Math.PI));
                    poseStack.scale(1.511f, 1.511f, 1.511f);
                    poseStack.translate(0.0, -0.55, 0.15);
                    model.renderToBuffer(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
                    poseStack.popPose();
                }
            });
        }
    }

    protected HumanoidModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
        Model basicModel = ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlot)slot, (HumanoidModel)model);
        return basicModel instanceof HumanoidModel ? (HumanoidModel)basicModel : model;
    }
}

