/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.player;

import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityAxeAttack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib.animation.Animation;

public class WroughtAxeSwingAbility
extends PlayerAbility {
    private EntityAxeAttack axeAttack;

    public WroughtAxeSwingAbility(AbilityType<Player, WroughtAxeSwingAbility> abilityType, Player user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, EntityAxeAttack.SWING_DURATION_HOR / 2 - 2), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, EntityAxeAttack.SWING_DURATION_HOR / 2 + 2 + 7)});
    }

    @Override
    public void start() {
        super.start();
        if (!((Player)this.getUser()).level().isClientSide()) {
            EntityAxeAttack axeAttack = new EntityAxeAttack((EntityType<? extends EntityAxeAttack>)((EntityType)EntityHandler.AXE_ATTACK.get()), ((Player)this.getUser()).level(), (LivingEntity)this.getUser(), false);
            axeAttack.absMoveTo(((Player)this.getUser()).getX(), ((Player)this.getUser()).getY(), ((Player)this.getUser()).getZ(), ((Player)this.getUser()).getYRot(), ((Player)this.getUser()).getXRot());
            ((Player)this.getUser()).level().addFreshEntity((Entity)axeAttack);
            this.axeAttack = axeAttack;
        } else {
            boolean handSide = ((Player)this.getUser()).getMainArm() == HumanoidArm.RIGHT;
            this.playAnimation("axe_swing_start_" + (handSide ? "right" : "left"), GeckoPlayer.Perspective.THIRD_PERSON, Animation.LoopType.PLAY_ONCE);
            this.playAnimation("axe_swing_start", GeckoPlayer.Perspective.FIRST_PERSON, Animation.LoopType.PLAY_ONCE);
            this.heldItemMainHandVisualOverride = ((Player)this.getUser()).getMainHandItem();
        }
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        if (this.getTicksInUse() == EntityAxeAttack.SWING_DURATION_HOR && this.getUser() instanceof Player) {
            Player player = (Player)this.getUser();
            player.resetAttackStrengthTicker();
        }
    }

    @Override
    public void end() {
        super.end();
        if (this.axeAttack != null) {
            this.axeAttack.discard();
        }
    }

    @Override
    public boolean preventsAttacking() {
        return false;
    }
}

