/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import software.bernie.geckolib.animation.RawAnimation;

public class GroundSlamAbility
extends PlayerAbility {
    private static final RawAnimation GROUND_POUND_LOOP_ANIM = RawAnimation.begin().thenLoop("ground_pound_loop");
    private static final RawAnimation GROUND_POUND_LAND_ANIM = RawAnimation.begin().thenPlay("ground_pound_land");

    public GroundSlamAbility(AbilityType<Player, ? extends Ability> abilityType, Player user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 2), new AbilitySection.AbilitySectionInfinite(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 21)});
    }

    @Override
    public void start() {
        super.start();
        this.playAnimation(GROUND_POUND_LOOP_ANIM);
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
            // empty if block
        }
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
            ((Player)this.getUser()).setDeltaMovement(0.0, -1.5, 0.0);
            if (((Player)this.getUser()).onGround()) {
                this.nextSection();
                for (LivingEntity livingentity : ((Player)this.getUser()).level().getEntitiesOfClass(LivingEntity.class, ((Player)this.getUser()).getBoundingBox().inflate(5.2, 2.0, 5.2))) {
                    livingentity.hurt(((Player)this.getUser()).damageSources().mobAttack(this.getUser()), 10.0f);
                }
                EntityCameraShake.cameraShake(((Player)this.getUser()).level(), ((Player)this.getUser()).position(), 45.0f, 0.09f, 20, 20);
                BlockState blockBeneath = ((Player)this.getUser()).level().getBlockState(((Player)this.getUser()).blockPosition());
                if (((Player)this.getUser()).level().isClientSide) {
                    ((Player)this.getUser()).playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.5f, 1.0f);
                    for (int i = 0; i < 50; ++i) {
                        ((Player)this.getUser()).level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockBeneath), ((Player)this.getUser()).getRandomX(5.8), (double)((float)((Player)this.getUser()).getBlockY() + 0.1f), ((Player)this.getUser()).getRandomZ(5.8), 0.0, 0.38, 0.0);
                        ((Player)this.getUser()).level().addParticle((ParticleOptions)ParticleTypes.POOF, ((Player)this.getUser()).getRandomX(5.0), ((Player)this.getUser()).getY(), ((Player)this.getUser()).getRandomZ(5.0), 0.0, 0.08, 0.0);
                    }
                    AdvancedParticleBase.spawnParticle(((Player)this.getUser()).level(), ParticleHandler.RING2, (float)((Player)this.getUser()).getX(), (float)((Player)this.getUser()).getY() + 0.01f, (float)((Player)this.getUser()).getZ(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.8f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, 136.0f), false)});
                }
            }
        }
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY) {
            ((Player)this.getUser()).setDeltaMovement(0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean canUse() {
        if (this.getUser() instanceof Player && !((Player)this.getUser()).getInventory().getSelected().isEmpty()) {
            return false;
        }
        return EffectGeomancy.canUse(this.getUser()) && ((Player)this.getUser()).fallDistance > 2.0f && super.canUse();
    }

    @Override
    public void nextSection() {
        super.nextSection();
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
            // empty if block
        }
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY) {
            this.playAnimation(GROUND_POUND_LAND_ANIM);
        }
    }

    @Override
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        super.onRightClickEmpty(event);
        if (!((Player)this.getUser()).onGround() && ((Player)this.getUser()).isCrouching()) {
            AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.GROUND_SLAM_ABILITY);
        }
    }
}

