/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy;

import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy.HeliomancyAbilityBase;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import software.bernie.geckolib.animation.RawAnimation;

public class SolarFlareAbility
extends HeliomancyAbilityBase {
    private static final RawAnimation SOLAR_FLARE_ANIM = RawAnimation.begin().thenPlay("solar_flare");

    public SolarFlareAbility(AbilityType<Player, SolarFlareAbility> abilityType, Player user) {
        super(abilityType, user, EntityUmvuthi.SolarFlareAbility.SECTION_TRACK);
    }

    @Override
    public void start() {
        super.start();
        ((Player)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_BURST.get(), 1.7f, 1.5f);
        this.playAnimation(SOLAR_FLARE_ANIM);
        if (this.getLevel().isClientSide) {
            this.heldItemMainHandVisualOverride = ItemStack.EMPTY;
            this.heldItemOffHandVisualOverride = ItemStack.EMPTY;
            this.firstPersonOffHandDisplay = PlayerAbility.HandDisplay.FORCE_RENDER;
            this.firstPersonMainHandDisplay = PlayerAbility.HandDisplay.FORCE_RENDER;
        }
    }

    @Override
    public boolean canUse() {
        if (this.getUser() == null || !((Player)this.getUser()).getInventory().getSelected().isEmpty()) {
            return false;
        }
        return ((Player)this.getUser()).hasEffect(EffectHandler.SUNS_BLESSING) && super.canUse();
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        if (this.getTicksInUse() < 16) {
            ((Player)this.getUser()).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 2, 2, false, false));
        }
        if (this.getTicksInUse() <= 6 && this.getLevel().isClientSide) {
            int particleCount = 8;
            while (--particleCount != 0) {
                double radius = 2.0;
                double yaw = (double)(this.rand.nextFloat() * 2.0f) * Math.PI;
                double pitch = (double)(this.rand.nextFloat() * 2.0f) * Math.PI;
                double ox = radius * Math.sin(yaw) * Math.sin(pitch);
                double oy = radius * Math.cos(pitch);
                double oz = radius * Math.cos(yaw) * Math.sin(pitch);
                this.getLevel().addParticle((ParticleOptions)ParticleOrb.Data.create((float)((Player)this.getUser()).getX(), (float)((Player)this.getUser()).getY() + ((Player)this.getUser()).getBbHeight() / 2.0f, (float)((Player)this.getUser()).getZ(), 6.0f), ((Player)this.getUser()).getX() + ox, ((Player)this.getUser()).getY() + (double)(((Player)this.getUser()).getBbHeight() / 2.0f) + oy, ((Player)this.getUser()).getZ() + oz, 0.0, 0.0, 0.0);
            }
        }
        if (this.getTicksInUse() == 10 && this.getLevel().isClientSide) {
            for (int i = 0; i < 30; ++i) {
                float velocity = 0.25f;
                float yaw = (float)i * 0.20943952f;
                float vy = this.rand.nextFloat() * 0.1f - 0.05f;
                float vx = 0.25f * Mth.cos((float)yaw);
                float vz = 0.25f * Mth.sin((float)yaw);
                this.getLevel().addParticle((ParticleOptions)ParticleTypes.FLAME, ((Player)this.getUser()).getX(), ((Player)this.getUser()).getY() + 1.0, ((Player)this.getUser()).getZ(), (double)vx, (double)vy, (double)vz);
            }
        }
    }

    @Override
    protected void beginSection(AbilitySection section) {
        super.beginSection(section);
        if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
            Player user = (Player)this.getUser();
            float radius = 3.2f;
            List<LivingEntity> hit = this.getEntityLivingBaseNearby((LivingEntity)user, radius, radius, radius, radius);
            for (LivingEntity aHit : hit) {
                Vec3 vec3;
                if (aHit == this.getUser()) continue;
                float damage = 2.0f;
                float knockback = 3.0f;
                damage = (float)((double)damage * (Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SUNS_BLESSING.sunsBlessingAttackMultiplier.get());
                if (!aHit.hurt(user.damageSources().playerAttack(user), damage) || !(knockback > 0.0f) || !((vec3 = aHit.position().subtract(user.position()).normalize().scale((double)knockback * 0.6)).lengthSqr() > 0.0)) continue;
                aHit.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    @Override
    public void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        super.onLeftClickEmpty(event);
        if (event.getEntity() == this.getUser() && event.getEntity().isShiftKeyDown()) {
            AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SOLAR_FLARE_ABILITY);
        }
    }

    @Override
    public void onLeftClickEntity(AttackEntityEvent event) {
        super.onLeftClickEntity(event);
        if (event.getEntity() == this.getUser() && event.getEntity().isShiftKeyDown()) {
            AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SOLAR_FLARE_ABILITY);
        }
    }
}

