/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai;

import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;

public class UmvuthanaHurtByTargetAI
extends HurtByTargetGoal {
    private boolean checkSight;
    private int unseenTicks;

    public UmvuthanaHurtByTargetAI(PathfinderMob entity, boolean checkSight, Class<?> ... p_26040_) {
        super(entity, (Class[])p_26040_);
        this.setAlertOthers(new Class[0]);
        this.checkSight = checkSight;
    }

    protected void alertOthers() {
        double d0 = this.getFollowDistance();
        AABB aabb = AABB.unitCubeFromLowerCorner((Vec3)this.mob.position()).inflate(d0, 10.0, d0);
        List listUmvuthana = this.mob.level().getEntitiesOfClass(EntityUmvuthana.class, aabb, EntitySelector.NO_SPECTATORS.and(e -> ((EntityUmvuthana)e).isUmvuthiDevoted()));
        List listUmvuthi = this.mob.level().getEntitiesOfClass(EntityUmvuthi.class, aabb, EntitySelector.NO_SPECTATORS);
        ArrayList list = new ArrayList();
        list.addAll(listUmvuthana);
        list.addAll(listUmvuthi);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Mob mob = (Mob)iterator.next();
            if (this.mob == mob || mob.getTarget() != null || this.mob instanceof TamableAnimal && ((TamableAnimal)this.mob).getOwner() != ((TamableAnimal)mob).getOwner() || mob.isAlliedTo((Entity)this.mob.getLastHurtByMob())) continue;
            if (this.toIgnoreAlert != null) {
                boolean flag = false;
                for (Class oclass : this.toIgnoreAlert) {
                    if (mob.getClass() != oclass) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
            }
            this.alertOther(mob, this.mob.getLastHurtByMob());
        }
        return;
    }

    protected double getFollowDistance() {
        return super.getFollowDistance() * 1.7;
    }

    public boolean canContinueToUse() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity == null) {
            livingentity = this.targetMob;
        }
        if (livingentity == null) {
            return false;
        }
        if (!this.mob.canAttack(livingentity)) {
            return false;
        }
        PlayerTeam team = this.mob.getTeam();
        PlayerTeam team1 = livingentity.getTeam();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.getFollowDistance();
        if (this.mob.distanceToSqr((Entity)livingentity) > d0 * d0) {
            return false;
        }
        if (this.checkSight) {
            if (this.mob.getSensing().hasLineOfSight((Entity)livingentity)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > UmvuthanaHurtByTargetAI.reducedTickDelay((int)this.unseenMemoryTicks)) {
                return false;
            }
        }
        this.mob.setTarget(livingentity);
        return true;
    }

    public void start() {
        super.start();
        this.unseenTicks = 0;
    }
}

