/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.umvuthana;

import com.bobmowzie.mowziesmobs.server.ai.UmvuthanaHurtByTargetAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaFollower;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaFollowerToRaptor;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.MaskType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;

public class EntityUmvuthanaRaptor
extends EntityUmvuthana
implements LeaderSunstrikeImmune,
Enemy {
    private final List<EntityUmvuthanaFollowerToRaptor> pack = new ArrayList<EntityUmvuthanaFollowerToRaptor>();
    private final int packRadius = 3;

    public EntityUmvuthanaRaptor(EntityType<? extends EntityUmvuthanaRaptor> type, Level world) {
        super((EntityType<? extends EntityUmvuthana>)type, world);
        this.setMask(MaskType.FURY);
        this.xpReward = 8;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new UmvuthanaHurtByTargetAI(this, true, new Class[0]));
    }

    @Override
    protected void registerTargetGoals() {
        this.registerHuntingTargetGoals();
    }

    @Override
    protected boolean canHoldVaryingWeapons() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.MAX_HEALTH, 10.0);
    }

    @Override
    public void tick() {
        super.tick();
        for (int i = 0; i < this.pack.size(); ++i) {
            this.pack.get((int)i).index = i;
        }
        if (!this.level().isClientSide && this.pack != null) {
            float theta = (float)Math.PI * 2 / (float)this.pack.size();
            for (int i = 0; i < this.pack.size(); ++i) {
                EntityUmvuthanaFollowerToRaptor hunter = this.pack.get(i);
                if (hunter.getTarget() != null) continue;
                hunter.getNavigation().moveTo(this.getX() + (double)(3.0f * Mth.cos((float)(theta * (float)i))), this.getY(), this.getZ() + (double)(3.0f * Mth.sin((float)(theta * (float)i))), 0.45);
                if (!(this.distanceTo((Entity)hunter) > 20.0f) || !this.onGround()) continue;
                hunter.setPos(this.getX() + (double)(3.0f * Mth.cos((float)(theta * (float)i))), this.getY(), this.getZ() + (double)(3.0f * Mth.sin((float)(theta * (float)i))));
            }
        }
        if (!this.level().isClientSide && this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.discard();
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (this.tickCount == 0) {
            this.pack.forEach(EntityUmvuthanaFollower::setShouldSetDead);
        }
        this.pack.forEach(EntityUmvuthanaFollowerToRaptor::removeLeader);
        super.remove(reason);
    }

    public boolean checkSpawnObstruction(LevelReader worldReader) {
        if (this.tickCount == 0) {
            return !worldReader.containsAnyLiquid(this.getBoundingBox()) && worldReader.noCollision((Entity)this);
        }
        return !worldReader.containsAnyLiquid(this.getBoundingBox()) && worldReader.noCollision((Entity)this) && this.level().isUnobstructed((Entity)this);
    }

    public void removePackMember(EntityUmvuthanaFollowerToRaptor tribeHunter) {
        this.pack.remove(tribeHunter);
        this.sortPackMembers();
    }

    public void addPackMember(EntityUmvuthanaFollowerToRaptor tribeHunter) {
        this.pack.add(tribeHunter);
        this.sortPackMembers();
    }

    private void sortPackMembers() {
        double theta = Math.PI * 2 / (double)this.pack.size();
        for (int i = 0; i < this.pack.size(); ++i) {
            int nearestIndex = -1;
            double smallestDiffSq = Double.MAX_VALUE;
            double targetTheta = theta * (double)i;
            double x = this.getX() + 3.0 * Math.cos(targetTheta);
            double z = this.getZ() + 3.0 * Math.sin(targetTheta);
            for (int n = 0; n < this.pack.size(); ++n) {
                EntityUmvuthanaFollowerToRaptor tribeHunter = this.pack.get(n);
                double diffSq = (x - tribeHunter.getX()) * (x - tribeHunter.getX()) + (z - tribeHunter.getZ()) * (z - tribeHunter.getZ());
                if (!(diffSq < smallestDiffSq)) continue;
                smallestDiffSq = diffSq;
                nearestIndex = n;
            }
            if (nearestIndex == -1) {
                throw new ArithmeticException("All pack members have NaN x and z?");
            }
            this.pack.add(i, this.pack.remove(nearestIndex));
        }
    }

    public int getPackSize() {
        return this.pack.size();
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingData) {
        int size = this.random.nextInt(2) + 3;
        float theta = (float)Math.PI * 2 / (float)size;
        for (int i = 0; i <= size; ++i) {
            EntityUmvuthanaFollowerToRaptor tribeHunter = new EntityUmvuthanaFollowerToRaptor((EntityType<? extends EntityUmvuthanaFollowerToRaptor>)((EntityType)EntityHandler.UMVUTHANA_FOLLOWER_TO_RAPTOR.get()), this.level(), this);
            tribeHunter.setPos(this.getX() + 0.1 * (double)Mth.cos((float)(theta * (float)i)), this.getY(), this.getZ() + 0.1 * (double)Mth.sin((float)(theta * (float)i)));
            int weapon = this.random.nextInt(3) == 0 ? 1 : 0;
            tribeHunter.setWeapon(weapon);
            world.addFreshEntity((Entity)tribeHunter);
        }
        return super.finalizeSpawn(world, difficulty, reason, livingData);
    }

    @Override
    public void die(DamageSource source) {
        super.die(source);
        this.pack.forEach(EntityUmvuthanaFollowerToRaptor::removeLeader);
    }

    @Override
    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return ConfigHandler.COMMON.MOBS.UMVUTHANA.spawnConfig;
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType reason) {
        List<LivingEntity> nearby = this.getEntityLivingBaseNearby(30.0, 10.0, 30.0, 30.0);
        for (LivingEntity nearbyEntity : nearby) {
            if (!(nearbyEntity instanceof EntityUmvuthanaRaptor) && !(nearbyEntity instanceof Villager) && !(nearbyEntity instanceof EntityUmvuthi) && !(nearbyEntity instanceof Animal)) continue;
            return false;
        }
        return super.checkSpawnRules(world, reason) && world.getDifficulty() != Difficulty.PEACEFUL;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @Override
    public void checkDespawn() {
        if (EventHooks.checkMobDespawn((Mob)this)) {
            return;
        }
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
        } else if (!this.isPersistenceRequired() && !this.requiresCustomPersistence()) {
            Player entity = this.level().getNearestPlayer((Entity)this, -1.0);
            if (entity != null) {
                int despawnDistance;
                int despawnRadius;
                double distance = entity.distanceToSqr((Entity)this);
                if (distance > (double)(despawnRadius = (despawnDistance = this.getDespawnDistance()) * despawnDistance) && this.removeWhenFarAway(distance)) {
                    if (this.pack != null) {
                        this.pack.forEach(EntityUmvuthanaFollower::setShouldSetDead);
                    }
                    this.discard();
                }
                int noDespawnDistance = this.getNoDespawnDistance();
                int noDespawnRadius = noDespawnDistance * noDespawnDistance;
                if (this.noActionTime > 600 && this.random.nextInt(800) == 0 && distance > (double)noDespawnRadius && this.removeWhenFarAway(distance)) {
                    if (this.pack != null) {
                        this.pack.forEach(EntityUmvuthanaFollower::setShouldSetDead);
                    }
                    this.discard();
                } else if (distance < (double)noDespawnRadius) {
                    this.noActionTime = 0;
                }
            }
        } else {
            this.noActionTime = 0;
        }
    }
}

