/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.client.render.item.RenderEarthrendGauntlet;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import java.util.List;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemEarthrendGauntlet
extends DiggerItem
implements GeoItem {
    public static final String CONTROLLER_NAME = "controller";
    public static final String CONTROLLER_IDLE_NAME = "controller_idle";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation OPEN_ANIM = RawAnimation.begin().thenLoop("open");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("attack");
    public static final String IDLE_ANIM_NAME = "idle";
    public static final String OPEN_ANIM_NAME = "open";
    public static final String ATTACK_ANIM_NAME = "attack";

    public ItemEarthrendGauntlet(Item.Properties properties) {
        super((Tier)Tiers.STONE, BlockTags.MINEABLE_WITH_PICKAXE, properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack stack = player.getItemInHand(handIn);
        player.startUsingItem(handIn);
        if (stack.getDamageValue() + 5 < stack.getMaxDamage() || ((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.breakable.get()).booleanValue()) {
            if (!worldIn.isClientSide()) {
                AbilityHandler.INSTANCE.sendAbilityMessage(player, AbilityHandler.TUNNELING_ABILITY);
            }
            player.startUsingItem(handIn);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(handIn));
        }
        DataHandler.getData((Entity)player, DataHandler.ABILITY_DATA).getAbilityMap().get(AbilityHandler.TUNNELING_ABILITY).end();
        return super.use(worldIn, player, handIn);
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 72000;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.durability.get();
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.0")).setStyle(ItemHandler.TOOLTIP_STYLE));
        if (((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.enableTunneling.get()).booleanValue()) {
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.1")).setStyle(ItemHandler.TOOLTIP_STYLE));
        }
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.2")).setStyle(ItemHandler.TOOLTIP_STYLE));
        if (!((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.breakable.get()).booleanValue()) {
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.3")).setStyle(ItemHandler.TOOLTIP_STYLE));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, CONTROLLER_IDLE_NAME, 3, this::predicateIdle));
        controllers.add(new AnimationController((GeoAnimatable)this, CONTROLLER_NAME, 3, state -> PlayState.STOP).triggerableAnim(IDLE_ANIM_NAME, IDLE_ANIM).triggerableAnim(OPEN_ANIM_NAME, OPEN_ANIM).triggerableAnim(ATTACK_ANIM_NAME, ATTACK_ANIM));
    }

    public <P extends Item> PlayState predicateIdle(AnimationState<P> event) {
        event.getController().setAnimation(IDLE_ANIM);
        return PlayState.CONTINUE;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        if (DataHandler.getData((Entity)entity, DataHandler.ABILITY_DATA).getActiveAbility() == null && entity.getUseItem() != stack && entity.level() instanceof ServerLevel) {
            this.triggerAnim((Entity)entity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)entity.level())), CONTROLLER_NAME, ATTACK_ANIM_NAME);
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.getUseItem() != stack && entity.level() instanceof ServerLevel) {
            this.triggerAnim(entity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)entity.level())), CONTROLLER_NAME, ATTACK_ANIM_NAME);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static class ClientExtensions
    implements IClientItemExtensions {
        private final BlockEntityWithoutLevelRenderer renderer = new RenderEarthrendGauntlet();

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return this.renderer;
        }
    }
}

