/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message.mouse;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.capability.AbilityData;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerData;
import com.bobmowzie.mowziesmobs.server.power.Power;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record MessageLeftMouseUp() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageLeftMouseUp> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"message_left_mouse_up"));
    public static final StreamCodec<ByteBuf, MessageLeftMouseUp> STREAM_CODEC = StreamCodec.unit((Object)new MessageLeftMouseUp());

    public static void handleServer(MessageLeftMouseUp packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            PlayerData data = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA);
            data.setMouseLeftDown(false);
            for (Power power : data.getPowers()) {
                power.onLeftMouseUp(player);
            }
            AbilityData abilityData = DataHandler.getData((Entity)player, DataHandler.ABILITY_DATA);
            if (abilityData != null) {
                for (Ability<?> ability : abilityData.getAbilities()) {
                    if (!(ability instanceof PlayerAbility)) continue;
                    PlayerAbility playerAbility = (PlayerAbility)ability;
                    playerAbility.onLeftMouseUp(player);
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

