/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.MowzieStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.StructureTypeHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.UmvuthanaGrovePieces;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class UmvuthanaGroveStructure
extends MowzieStructure {
    public static final MapCodec<UmvuthanaGroveStructure> CODEC = UmvuthanaGroveStructure.simpleCodec(UmvuthanaGroveStructure::new);

    public UmvuthanaGroveStructure(Structure.StructureSettings settings) {
        super(settings, ConfigHandler.COMMON.MOBS.UMVUTHI.generationConfig, StructureTypeHandler.UMVUTHI_BIOMES);
    }

    @Override
    public void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        Rotation rotation = Rotation.values()[context.random().nextInt(Rotation.values().length)];
        int x = (context.chunkPos().x << 4) + 7;
        int z = (context.chunkPos().z << 4) + 7;
        BlockPos centerPos = new BlockPos(x, 1, z);
        ChunkGenerator generator = context.chunkGenerator();
        LevelHeightAccessor heightLimitView = context.heightAccessor();
        WorldgenRandom random = context.random();
        int surfaceY = generator.getBaseHeight(centerPos.getX(), centerPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, context.randomState());
        int oceanFloorY = generator.getBaseHeight(centerPos.getX(), centerPos.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView, context.randomState());
        if (oceanFloorY < surfaceY) {
            return;
        }
        BlockPos firepitPos = UmvuthanaGroveStructure.posToSurface(generator, centerPos, heightLimitView, context.randomState());
        builder.addPiece((StructurePiece)new UmvuthanaGrovePieces.FirepitPiece(context.structureTemplateManager(), Rotation.values()[random.nextInt(Rotation.values().length)], firepitPos));
        BlockPos offset = new BlockPos(0, 0, 9);
        offset = offset.rotate(rotation);
        BlockPos thronePos = UmvuthanaGroveStructure.posToSurface(generator, centerPos.offset((Vec3i)offset), heightLimitView, context.randomState());
        UmvuthanaGrovePieces.addPiece(UmvuthanaGrovePieces.THRONE, context.structureTemplateManager(), thronePos, rotation, (StructurePieceAccessor)builder, context.random());
        int numHouses = random.nextInt(2) + 2;
        block0: for (int i = 1; i <= numHouses; ++i) {
            for (int j = 0; j < 30; ++j) {
                float distance = random.nextInt(8) + 13;
                int angle = random.nextInt(360);
                BlockPos housePos = BlockPos.containing((double)((double)centerPos.getX() + (double)distance * Math.sin(Math.toRadians(angle))), (double)0.0, (double)((double)centerPos.getZ() + (double)distance * Math.cos(Math.toRadians(angle))));
                int houseOceanFloorY = generator.getBaseHeight((housePos = UmvuthanaGroveStructure.posToSurface(generator, housePos, heightLimitView, context.randomState())).getX(), housePos.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView, context.randomState());
                if (houseOceanFloorY >= housePos.getY() && UmvuthanaGroveStructure.startPlatform(generator, context.structureTemplateManager(), builder, housePos, context.random())) continue block0;
            }
        }
        int numTrees = random.nextInt(3) + 2;
        block2: for (int i = 1; i <= numTrees; ++i) {
            for (int j = 0; j < 30; ++j) {
                int whichTree;
                StructurePiece tree;
                float distance = random.nextInt(14) + 13;
                int angle = random.nextInt(360);
                BlockPos treePos = BlockPos.containing((double)((double)centerPos.getX() + (double)distance * Math.sin(Math.toRadians(angle))), (double)0.0, (double)((double)centerPos.getZ() + (double)distance * Math.cos(Math.toRadians(angle))));
                int treeOceanFloorY = generator.getBaseHeight((treePos = UmvuthanaGroveStructure.posToSurface(generator, treePos, heightLimitView, context.randomState())).getX(), treePos.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView, context.randomState());
                if (treeOceanFloorY >= treePos.getY() && (tree = UmvuthanaGrovePieces.addPieceCheckBounds(UmvuthanaGrovePieces.TREES[whichTree = random.nextInt(UmvuthanaGrovePieces.TREES.length)], context.structureTemplateManager(), treePos, Rotation.values()[random.nextInt(Rotation.values().length)], builder, context.random())) != null) continue block2;
            }
        }
        int numFirepits = random.nextInt(3) + 2;
        block4: for (int i = 1; i <= numFirepits; ++i) {
            for (int j = 1; j <= 10; ++j) {
                ResourceLocation whichPit;
                StructurePiece piece;
                int distance = random.nextInt(15) + 8;
                int angle = random.nextInt(360);
                BlockPos pitPos = BlockPos.containing((double)((double)centerPos.getX() + (double)distance * Math.sin(Math.toRadians(angle))), (double)0.0, (double)((double)centerPos.getZ() + (double)distance * Math.cos(Math.toRadians(angle))));
                int pitOceanFloorY = generator.getBaseHeight((pitPos = UmvuthanaGroveStructure.posToSurface(generator, pitPos, heightLimitView, context.randomState())).getX(), pitPos.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView, context.randomState());
                if (pitOceanFloorY >= pitPos.getY() && (piece = UmvuthanaGrovePieces.addPieceCheckBounds(whichPit = UmvuthanaGrovePieces.FIREPIT_SMALL[random.nextInt(UmvuthanaGrovePieces.FIREPIT_SMALL.length)], context.structureTemplateManager(), pitPos, Rotation.values()[random.nextInt(Rotation.values().length)], builder, context.random())) != null) continue block4;
            }
        }
        int numStakes = random.nextInt(10) + 7;
        block6: for (int i = 1; i <= numStakes; ++i) {
            for (int j = 1; j <= 10; ++j) {
                ResourceLocation whichSpike;
                StructurePiece piece;
                int distance = random.nextInt(15) + 8;
                int angle = random.nextInt(360);
                BlockPos stakePos = BlockPos.containing((double)((double)centerPos.getX() + (double)distance * Math.sin(Math.toRadians(angle))), (double)0.0, (double)((double)centerPos.getZ() + (double)distance * Math.cos(Math.toRadians(angle))));
                int stakeOceanFloorY = generator.getBaseHeight((stakePos = UmvuthanaGroveStructure.posToSurface(generator, stakePos, heightLimitView, context.randomState())).getX(), stakePos.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView, context.randomState());
                if (stakeOceanFloorY >= stakePos.getY() && (piece = UmvuthanaGrovePieces.addPieceCheckBounds(whichSpike = UmvuthanaGrovePieces.SPIKES[random.nextInt(UmvuthanaGrovePieces.SPIKES.length)], context.structureTemplateManager(), stakePos, Rotation.values()[random.nextInt(Rotation.values().length)], builder, context.random())) != null) continue block6;
            }
        }
    }

    private static boolean startPlatform(ChunkGenerator generator, StructureTemplateManager templateManagerIn, StructurePiecesBuilder builder, BlockPos housePos, WorldgenRandom random) {
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        StructurePiece newPlatform = UmvuthanaGrovePieces.addPlatform(templateManagerIn, housePos, rotation, builder, random);
        return newPlatform != null;
    }

    private static BlockPos posToSurface(ChunkGenerator generator, BlockPos pos, LevelHeightAccessor heightAccessor, RandomState state) {
        int surfaceY = generator.getBaseHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, state);
        return new BlockPos(pos.getX(), surfaceY - 1, pos.getZ());
    }

    public StructureType<?> type() {
        return (StructureType)StructureTypeHandler.UMVUTHANA_GROVE.get();
    }
}

