/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.MowzieStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.StructureTypeHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.WroughtnautChamberPieces;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class WroughtnautChamberStructure
extends MowzieStructure {
    public static final MapCodec<WroughtnautChamberStructure> CODEC = WroughtnautChamberStructure.simpleCodec(WroughtnautChamberStructure::new);

    public WroughtnautChamberStructure(Structure.StructureSettings settings) {
        super(settings, ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig, StructureTypeHandler.FERROUS_WROUGHTNAUT_BIOMES, false, false, true);
    }

    @Override
    public void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        int x = context.chunkPos().getMiddleBlockX();
        int z = context.chunkPos().getMiddleBlockZ();
        int y = context.chunkGenerator().getFirstOccupiedHeight(x, z, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        Pair<BlockPos, Rotation> tryResult = WroughtnautChamberStructure.tryWroughtChamber(context.chunkGenerator(), context.heightAccessor(), x, y, z, context.randomState());
        if (tryResult == null) {
            return;
        }
        BlockPos pos = (BlockPos)tryResult.getLeft();
        Rotation rotation = (Rotation)tryResult.getRight();
        BlockPos rotationOffset = new BlockPos(0, 0, -9).rotate(rotation);
        pos = pos.offset((Vec3i)rotationOffset);
        WroughtnautChamberPieces.start(context.structureTemplateManager(), pos, rotation, (StructurePieceAccessor)builder);
    }

    @Nullable
    public static Pair<BlockPos, Rotation> tryWroughtChamber(ChunkGenerator generator, LevelHeightAccessor heightAccessor, int x, int surfaceY, int z, RandomState state) {
        int xzCheckDistance = 8;
        int heightMax = ((Double)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.heightMax.get()).intValue();
        int heightMin = ((Double)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.heightMin.get()).intValue();
        if (heightMax == -65 || heightMax > surfaceY) {
            heightMax = surfaceY;
        }
        if (heightMin == -65) {
            heightMin = -64;
        }
        for (int dx = -xzCheckDistance; dx < xzCheckDistance; dx += 2) {
            for (int dz = -xzCheckDistance; dz < xzCheckDistance; dz += 2) {
                BlockPos airPos = null;
                NoiseColumn column = generator.getBaseColumn(x + dx, z + dz, heightAccessor, state);
                for (int y = heightMax; y > heightMin; --y) {
                    if (column.getBlock(y).isSolid()) continue;
                    airPos = new BlockPos(x + dx, y, z + dz);
                    break;
                }
                if (airPos == null) continue;
                BlockPos groundPos = null;
                for (int y = airPos.getY(); y > heightMin; --y) {
                    if (!column.getBlock(y).isSolid()) continue;
                    groundPos = airPos.atY(y);
                    break;
                }
                if (groundPos == null) continue;
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos.MutableBlockPos checkWallPos = groundPos.above().mutable();
                    for (int d = 1; d <= xzCheckDistance; ++d) {
                        BlockState wallBlock;
                        checkWallPos.move(dir);
                        NoiseColumn wallCheckColumn = generator.getBaseColumn(checkWallPos.getX(), checkWallPos.getZ(), heightAccessor, state);
                        int wallBaseY = checkWallPos.getY() - 1;
                        int wallHeightCount = 1;
                        while ((wallBlock = wallCheckColumn.getBlock(checkWallPos.getY())).isSolid()) {
                            if (wallHeightCount == 4) {
                                Rotation rotation = switch (dir) {
                                    case Direction.NORTH -> Rotation.COUNTERCLOCKWISE_90;
                                    case Direction.EAST -> Rotation.NONE;
                                    case Direction.WEST -> Rotation.CLOCKWISE_180;
                                    default -> Rotation.CLOCKWISE_90;
                                };
                                return Pair.of((Object)new BlockPos(checkWallPos.getX(), wallBaseY, checkWallPos.getZ()), (Object)rotation);
                            }
                            checkWallPos.move(Direction.UP);
                            ++wallHeightCount;
                        }
                    }
                }
            }
        }
        return null;
    }

    @Override
    public GenerationStep.Decoration step() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    public StructureType<?> type() {
        return (StructureType)StructureTypeHandler.WROUGHTNAUT_CHAMBER.get();
    }
}

