/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure.jigsaw;

import com.bobmowzie.mowziesmobs.server.world.feature.structure.jigsaw.FallbackPoolElement;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.jigsaw.MowziePoolElement;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class MowzieJigsawManager {
    static final Logger LOGGER = LogUtils.getLogger();
    private static Map<String, Integer> poolPlaceOrder = new HashMap<String, Integer>();
    public static Comparator<Pair<StructureTemplate.StructureBlockInfo, PieceState>> placeOrderComparator;

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, Holder<StructureTemplatePool> pool, BlockPos genPos, boolean villageBoundaryAdjust, boolean useTerrainHeight, int maxDistFromStart, String pathJigsawName, String interiorJigsawName, Set<String> mustConnectPools, Set<String> replacePools, String deadEndConnectorPool, int maxDepth) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.setLargeFeatureSeed(context.seed(), context.chunkPos().x, context.chunkPos().z);
        RegistryAccess registryaccess = context.registryAccess();
        ChunkGenerator chunkgenerator = context.chunkGenerator();
        StructureTemplateManager structuremanager = context.structureTemplateManager();
        LevelHeightAccessor levelheightaccessor = context.heightAccessor();
        Predicate predicate = context.validBiome();
        Registry registry = registryaccess.registryOrThrow(Registries.TEMPLATE_POOL);
        Rotation rotation = Rotation.getRandom((RandomSource)worldgenrandom);
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)pool.value();
        StructurePoolElement structurepoolelement = structuretemplatepool.getRandomTemplate((RandomSource)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(structuremanager, structurepoolelement, genPos, structurepoolelement.getGroundLevelDelta(), rotation, structurepoolelement.getBoundingBox(structuremanager, genPos, rotation), LiquidSettings.IGNORE_WATERLOGGING);
        BoundingBox pieceBoundingBox = poolelementstructurepiece.getBoundingBox();
        BlockPos offset = BlockPos.ZERO;
        if (structurepoolelement instanceof MowziePoolElement) {
            offset = ((MowziePoolElement)structurepoolelement).bounds.offset;
            offset = offset.rotate(rotation);
        }
        int centerX = (pieceBoundingBox.maxX() + pieceBoundingBox.minX()) / 2;
        int centerZ = (pieceBoundingBox.maxZ() + pieceBoundingBox.minZ()) / 2;
        int height = useTerrainHeight ? genPos.getY() + chunkgenerator.getFirstFreeHeight(centerX + offset.getX(), centerZ + offset.getZ(), Heightmap.Types.WORLD_SURFACE_WG, levelheightaccessor, context.randomState()) + offset.getY() : genPos.getY();
        if (!predicate.test(chunkgenerator.getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)centerX), QuartPos.fromBlock((int)height), QuartPos.fromBlock((int)centerZ), context.randomState().sampler()))) {
            return Optional.empty();
        }
        int l = pieceBoundingBox.minY() + poolelementstructurepiece.getGroundLevelDelta();
        poolelementstructurepiece.move(0, height - l, 0);
        return Optional.of(new Structure.GenerationStub(new BlockPos(centerX, height, centerZ), builder -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (maxDepth >= 0) {
                AABB aabb = new AABB((double)(centerX - maxDistFromStart), (double)(height - maxDistFromStart), (double)(centerZ - maxDistFromStart), (double)(centerX + maxDistFromStart + 1), (double)(height + maxDistFromStart + 1), (double)(centerZ + maxDistFromStart + 1));
                VoxelShape shape = Shapes.join((VoxelShape)Shapes.create((AABB)aabb), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)pieceBoundingBox)), (BooleanOp)BooleanOp.ONLY_FIRST);
                MutableObject free = new MutableObject((Object)shape);
                MutableObject interiorFree = new MutableObject((Object)Shapes.empty());
                MutableObject specialBounds = new MutableObject(new HashMap());
                Placer placer = new Placer((Registry<StructureTemplatePool>)registry, maxDepth, chunkgenerator, structuremanager, list, (RandomSource)worldgenrandom, pathJigsawName, interiorJigsawName, (MutableObject<VoxelShape>)free, (MutableObject<VoxelShape>)interiorFree, (MutableObject<Map<String, VoxelShape>>)specialBounds);
                String tag = null;
                if (poolelementstructurepiece.getElement() instanceof MowziePoolElement) {
                    tag = ((MowziePoolElement)poolelementstructurepiece.getElement()).getRandomTag((RandomSource)worldgenrandom);
                }
                PieceState startingPiece = new PieceState(poolelementstructurepiece, 0, null, tag);
                for (StructureTemplate.StructureBlockInfo structureBlockInfo : placer.getJigsawBlocksFromPieceState(startingPiece)) {
                    placer.placing.add((Pair<StructureTemplate.StructureBlockInfo, PieceState>)new Pair((Object)structureBlockInfo, (Object)startingPiece));
                }
                while (!placer.placing.isEmpty()) {
                    Pair<StructureTemplate.StructureBlockInfo, PieceState> nextJigsawBlock = placer.placing.first();
                    placer.placing.remove(nextJigsawBlock);
                    if (((PieceState)nextJigsawBlock.getSecond()).depth > maxDepth) break;
                    placer.tryPlacingChildren((StructureTemplate.StructureBlockInfo)nextJigsawBlock.getFirst(), (PieceState)nextJigsawBlock.getSecond(), villageBoundaryAdjust, levelheightaccessor, context.randomState());
                }
                FallbackPlacer fallbackPlacer = new FallbackPlacer((Registry<StructureTemplatePool>)registry, maxDepth, chunkgenerator, structuremanager, list, (RandomSource)worldgenrandom, pathJigsawName, interiorJigsawName, (MutableObject<VoxelShape>)free, (MutableObject<VoxelShape>)interiorFree, (MutableObject<Map<String, VoxelShape>>)specialBounds, placer);
                while (!fallbackPlacer.placing.isEmpty()) {
                    Pair<StructureTemplate.StructureBlockInfo, PieceState> nextJigsawBlock = fallbackPlacer.placing.first();
                    fallbackPlacer.placing.remove(nextJigsawBlock);
                    fallbackPlacer.tryPlacingChildren((StructureTemplate.StructureBlockInfo)nextJigsawBlock.getFirst(), (PieceState)nextJigsawBlock.getSecond(), villageBoundaryAdjust, levelheightaccessor, context.randomState());
                }
                InteriorPlacer interiorPlacer = new InteriorPlacer((Registry<StructureTemplatePool>)registry, maxDepth, chunkgenerator, structuremanager, list, (RandomSource)worldgenrandom, pathJigsawName, interiorJigsawName, (MutableObject<VoxelShape>)free, (MutableObject<VoxelShape>)interiorFree, (MutableObject<Map<String, VoxelShape>>)specialBounds, fallbackPlacer);
                while (!interiorPlacer.placing.isEmpty()) {
                    Pair<StructureTemplate.StructureBlockInfo, PieceState> nextJigsawBlock = interiorPlacer.placing.first();
                    interiorPlacer.placing.remove(nextJigsawBlock);
                    interiorPlacer.tryPlacingChildren((StructureTemplate.StructureBlockInfo)nextJigsawBlock.getFirst(), (PieceState)nextJigsawBlock.getSecond(), villageBoundaryAdjust, levelheightaccessor, context.randomState());
                }
                list.sort((p1, p2) -> {
                    int i2 = 0;
                    int i1 = 0;
                    if (p1.getElement() instanceof MowziePoolElement) {
                        i1 = ((MowziePoolElement)p1.getElement()).genOrder;
                    }
                    if (p2.getElement() instanceof MowziePoolElement) {
                        i2 = ((MowziePoolElement)p2.getElement()).genOrder;
                    }
                    return Integer.compare(i1, i2);
                });
                list.forEach(arg_0 -> ((StructurePiecesBuilder)builder).addPiece(arg_0));
            }
        }));
    }

    static {
        poolPlaceOrder.put("mowziesmobs:monastery/interior/wall_corner_pool", -2);
        poolPlaceOrder.put("mowziesmobs:monastery/interior/wall_middle_pool", -2);
        poolPlaceOrder.put("mowziesmobs:monastery/interior/center_pool", -3);
        poolPlaceOrder.put("mowziesmobs:monastery/interior/blocker_pool", -4);
        poolPlaceOrder.put("mowziesmobs:monastery/interior/tower_stairs_1_pool", -5);
        poolPlaceOrder.put("mowziesmobs:monastery/interior/tower_stairs_2_pool", -5);
        poolPlaceOrder.put("mowziesmobs:monastery/interior/room_stairs_1_pool", -5);
        poolPlaceOrder.put("mowziesmobs:monastery/interior/room_stairs_2_pool", -5);
        placeOrderComparator = (p1, p2) -> {
            int p2Order;
            int p1Order = poolPlaceOrder.getOrDefault(((StructureTemplate.StructureBlockInfo)p1.getFirst()).nbt().getString("pool"), 0);
            int result = Integer.compare(p1Order, p2Order = poolPlaceOrder.getOrDefault(((StructureTemplate.StructureBlockInfo)p2.getFirst()).nbt().getString("pool"), 0).intValue());
            if (result == 0) {
                result = Integer.compare(((PieceState)p1.getSecond()).depth, ((PieceState)p2.getSecond()).depth);
            }
            if (result == 0) {
                result = Integer.compare(p1.hashCode(), p2.hashCode());
            }
            return result;
        };
    }

    static class PieceState {
        final PoolElementStructurePiece piece;
        final int depth;
        final PieceState parent;
        final Set<PieceState> children;
        final String tag;

        PieceState(PoolElementStructurePiece p_210311_, int p_210313_, PieceState parent, String tag) {
            this.piece = p_210311_;
            this.depth = p_210313_;
            this.parent = parent;
            this.children = new HashSet<PieceState>();
            this.tag = tag;
        }
    }

    static class Placer {
        final Registry<StructureTemplatePool> pools;
        final int maxDepth;
        final ChunkGenerator chunkGenerator;
        final StructureTemplateManager structureManager;
        final List<? super PoolElementStructurePiece> pieces;
        protected final RandomSource random;
        protected final String pathJigsawName;
        protected final String interiorJigsawName;
        MutableObject<VoxelShape> free;
        MutableObject<VoxelShape> interiorFree;
        MutableObject<Map<String, VoxelShape>> specialBounds;
        final SortedSet<Pair<StructureTemplate.StructureBlockInfo, PieceState>> placing = new TreeSet<Pair<StructureTemplate.StructureBlockInfo, PieceState>>(placeOrderComparator);
        final SortedSet<Pair<StructureTemplate.StructureBlockInfo, PieceState>> fallbacks = new TreeSet<Pair<StructureTemplate.StructureBlockInfo, PieceState>>(placeOrderComparator);
        final SortedSet<Pair<StructureTemplate.StructureBlockInfo, PieceState>> interior = new TreeSet<Pair<StructureTemplate.StructureBlockInfo, PieceState>>(placeOrderComparator);
        protected int numPaths;

        Placer(Registry<StructureTemplatePool> p_210323_, int p_210324_, ChunkGenerator p_210326_, StructureTemplateManager p_210327_, List<? super PoolElementStructurePiece> p_210328_, RandomSource p_210329_, String pathJigsawName, String interiorJigsawName, MutableObject<VoxelShape> free, MutableObject<VoxelShape> interiorFree, MutableObject<Map<String, VoxelShape>> specialBounds) {
            this.pools = p_210323_;
            this.maxDepth = p_210324_;
            this.chunkGenerator = p_210326_;
            this.structureManager = p_210327_;
            this.pieces = p_210328_;
            this.random = p_210329_;
            this.numPaths = 0;
            this.pathJigsawName = pathJigsawName;
            this.interiorJigsawName = interiorJigsawName;
            this.free = free;
            this.interiorFree = interiorFree;
            this.specialBounds = specialBounds;
        }

        void tryPlacingChildren(StructureTemplate.StructureBlockInfo thisPieceJigsawBlock, PieceState pieceState, boolean villageBoundaryAdjust, LevelHeightAccessor heightAccessor, RandomState state) {
            String pool;
            ResourceLocation poolResourceLocation;
            Optional poolOptional;
            if (this.skipJigsawBlock(thisPieceJigsawBlock, pieceState)) {
                return;
            }
            if (thisPieceJigsawBlock.nbt().getString("target").equals(this.pathJigsawName) && this.numPaths > 0) {
                --this.numPaths;
            }
            if ((poolOptional = this.pools.getOptional(poolResourceLocation = ResourceLocation.tryParse((String)(pool = this.selectPool(thisPieceJigsawBlock))))).isPresent() && (((StructureTemplatePool)poolOptional.get()).size() != 0 || Objects.equals(poolResourceLocation, Pools.EMPTY.location()))) {
                Holder fallbackPoolHolder = ((StructureTemplatePool)poolOptional.get()).getFallback();
                if (((StructureTemplatePool)fallbackPoolHolder.value()).size() != 0 || fallbackPoolHolder.is(Pools.EMPTY)) {
                    PieceSelection pieceSelection = this.selectPiece(pieceState, (StructureTemplatePool)poolOptional.get(), (StructureTemplatePool)fallbackPoolHolder.value(), villageBoundaryAdjust, thisPieceJigsawBlock, heightAccessor, state);
                    if (pieceSelection != null) {
                        this.addNextPieceState(pieceSelection);
                    }
                } else {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)fallbackPoolHolder.unwrapKey().map(p_255599_ -> p_255599_.location().toString()).orElse("<unregistered>"));
                }
            } else {
                LOGGER.warn("Empty or non-existent pool: {}", (Object)poolResourceLocation);
            }
        }

        protected boolean skipJigsawBlock(StructureTemplate.StructureBlockInfo thisPieceJigsawBlock, PieceState pieceState) {
            if (thisPieceJigsawBlock.nbt().getString("target").equals(this.interiorJigsawName)) {
                this.interior.add((Pair<StructureTemplate.StructureBlockInfo, PieceState>)Pair.of((Object)thisPieceJigsawBlock, (Object)pieceState));
                return true;
            }
            return false;
        }

        List<StructureTemplate.StructureBlockInfo> getJigsawBlocksFromPieceState(PieceState pieceState) {
            StructurePoolElement structurepoolelement = pieceState.piece.getElement();
            BlockPos blockpos = pieceState.piece.getPosition();
            Rotation rotation = pieceState.piece.getRotation();
            return structurepoolelement.getShuffledJigsawBlocks(this.structureManager, blockpos, rotation, this.random);
        }

        String selectPool(StructureTemplate.StructureBlockInfo thisPieceJigsawBlock) {
            return thisPieceJigsawBlock.nbt().getString("pool");
        }

        List<StructurePoolElement> addPoolElements(PieceState pieceState, StructureTemplatePool pool, StructureTemplatePool fallbackPool) {
            ArrayList structurePoolElements = Lists.newArrayList();
            structurePoolElements.addAll(pool.getShuffledTemplates(this.random));
            return structurePoolElements;
        }

        boolean isJigsawBlockFacingFreeSpace(StructureTemplate.StructureBlockInfo jigsawBlockInfo, MutableObject<VoxelShape> freeSpace) {
            Direction direction = JigsawBlock.getFrontFacing((BlockState)jigsawBlockInfo.state());
            BlockPos thisJigsawBlockPos = jigsawBlockInfo.pos();
            BlockPos nextJigsawBlockPos = thisJigsawBlockPos.relative(direction);
            AABB aabb = new AABB(nextJigsawBlockPos);
            return !Shapes.joinIsNotEmpty((VoxelShape)((VoxelShape)freeSpace.getValue()), (VoxelShape)Shapes.create((AABB)aabb.deflate(0.25)), (BooleanOp)BooleanOp.ONLY_SECOND);
        }

        boolean canJigsawBlockFitNextPiece(StructureTemplate.StructureBlockInfo jigsawBlockInfo, MutableObject<VoxelShape> freeSpace) {
            Direction direction = JigsawBlock.getFrontFacing((BlockState)jigsawBlockInfo.state());
            BlockPos thisJigsawBlockPos = jigsawBlockInfo.pos();
            BlockPos nextJigsawBlockPos = thisJigsawBlockPos.relative(direction);
            AABB aabb = new AABB(nextJigsawBlockPos);
            Vec3i offset = direction.getNormal();
            aabb = aabb.inflate(2.0).move((double)(offset.getX() * 2), (double)(offset.getY() * 2), (double)(offset.getZ() * 2));
            return !Shapes.joinIsNotEmpty((VoxelShape)((VoxelShape)freeSpace.getValue()), (VoxelShape)Shapes.create((AABB)aabb.deflate(0.25)), (BooleanOp)BooleanOp.ONLY_SECOND);
        }

        PieceSelection selectPiece(PieceState pieceState, StructureTemplatePool poolOptional, StructureTemplatePool fallbackPoolOptional, boolean villageBoundaryAdjust, StructureTemplate.StructureBlockInfo thisPieceJigsawBlock, LevelHeightAccessor heightAccessor, RandomState state) {
            BoundingBox thisPieceBoundingBox = pieceState.piece.getBoundingBox();
            int thisPieceMinY = thisPieceBoundingBox.minY();
            Direction direction = JigsawBlock.getFrontFacing((BlockState)thisPieceJigsawBlock.state());
            BlockPos thisJigsawBlockPos = thisPieceJigsawBlock.pos();
            BlockPos nextJigsawBlockPos = thisJigsawBlockPos.relative(direction);
            int thisPieceHeightFromBottomToJigsawBlock = thisJigsawBlockPos.getY() - thisPieceMinY;
            StructurePoolElement structurepoolelement = pieceState.piece.getElement();
            StructureTemplatePool.Projection structuretemplatepool$projection = structurepoolelement.getProjection();
            boolean thisPieceIsRigid = structuretemplatepool$projection == StructureTemplatePool.Projection.RIGID;
            int k = -1;
            List<StructurePoolElement> structurePoolElements = this.addPoolElements(pieceState, poolOptional, fallbackPoolOptional);
            structurePoolElements.sort((p1, p2) -> {
                int i2 = 0;
                int i1 = 0;
                if (p1 instanceof MowziePoolElement) {
                    i1 = ((MowziePoolElement)p1).priority;
                }
                if (p2 instanceof MowziePoolElement) {
                    i2 = ((MowziePoolElement)p2).priority;
                }
                return Integer.compare(i1, i2);
            });
            for (StructurePoolElement nextPieceCandidate : structurePoolElements) {
                MowziePoolElement mowziePoolElement;
                if (nextPieceCandidate == FallbackPoolElement.INSTANCE) break;
                if (nextPieceCandidate == EmptyPoolElement.INSTANCE || nextPieceCandidate instanceof SinglePoolElement && ((SinglePoolElement)nextPieceCandidate).toString().equals("Single[Left[minecraft:empty]]")) {
                    return null;
                }
                if (nextPieceCandidate instanceof MowziePoolElement && !(mowziePoolElement = (MowziePoolElement)nextPieceCandidate).checkCriteria(pieceState, this)) continue;
                for (Rotation nextPieceRotation : Rotation.getShuffled((RandomSource)this.random)) {
                    List nextPieceJigsawBlocks = nextPieceCandidate.getShuffledJigsawBlocks(this.structureManager, BlockPos.ZERO, nextPieceRotation, this.random);
                    BoundingBox nextPieceBoundingBoxOrigin = nextPieceCandidate.getBoundingBox(this.structureManager, BlockPos.ZERO, nextPieceRotation);
                    int largestSizeOfNextNextPiece = villageBoundaryAdjust && nextPieceBoundingBoxOrigin.getYSpan() <= 16 ? nextPieceJigsawBlocks.stream().mapToInt(blockInfo -> {
                        if (!nextPieceBoundingBoxOrigin.isInside((Vec3i)blockInfo.pos().relative(JigsawBlock.getFrontFacing((BlockState)blockInfo.state())))) {
                            return 0;
                        }
                        ResourceLocation resourcelocation2 = ResourceLocation.tryParse((String)blockInfo.nbt().getString("pool"));
                        Optional optional2 = this.pools.getOptional(resourcelocation2);
                        Optional<Integer> optional3 = optional2.flatMap(p_210344_ -> this.pools.getOptional((ResourceKey)p_210344_.getFallback().unwrapKey().get()));
                        int j3 = optional2.map(structureTemplatePool -> structureTemplatePool.getMaxSize(this.structureManager)).orElse(0);
                        int k3 = optional3.map(structureTemplatePool -> structureTemplatePool.getMaxSize(this.structureManager)).orElse(0);
                        return Math.max(j3, k3);
                    }).max().orElse(0) : 0;
                    for (StructureTemplate.StructureBlockInfo nextPieceJigsawBlock : nextPieceJigsawBlocks) {
                        int l2;
                        int l1;
                        StructureTemplatePool.Projection structuretemplatepool$projection1;
                        boolean canAttach = nextPieceCandidate instanceof MowziePoolElement && ((MowziePoolElement)nextPieceCandidate).twoWay() ? MowziePoolElement.canAttachTwoWays(thisPieceJigsawBlock, nextPieceJigsawBlock) : JigsawBlock.canAttach((StructureTemplate.StructureBlockInfo)thisPieceJigsawBlock, (StructureTemplate.StructureBlockInfo)nextPieceJigsawBlock);
                        if (!canAttach) continue;
                        BlockPos nextPieceJigsawBlockPos = nextPieceJigsawBlock.pos();
                        BlockPos nextPiecePos = nextJigsawBlockPos.subtract((Vec3i)nextPieceJigsawBlockPos);
                        BoundingBox nextPieceBoundingBox = nextPieceCandidate.getBoundingBox(this.structureManager, nextPiecePos, nextPieceRotation);
                        int nextPieceMinY = nextPieceBoundingBox.minY();
                        if (nextPieceCandidate instanceof MowziePoolElement) {
                            nextPieceMinY -= ((MowziePoolElement)nextPieceCandidate).bounds.boundsMinOffset.getY();
                        }
                        boolean nextPieceIsRigid = (structuretemplatepool$projection1 = nextPieceCandidate.getProjection()) == StructureTemplatePool.Projection.RIGID;
                        int nextPieceJigsawBlockY = nextPieceJigsawBlockPos.getY();
                        int k1 = thisPieceHeightFromBottomToJigsawBlock - nextPieceJigsawBlockY + JigsawBlock.getFrontFacing((BlockState)thisPieceJigsawBlock.state()).getStepY();
                        if (thisPieceIsRigid && nextPieceIsRigid) {
                            l1 = thisPieceMinY + k1;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.getFirstFreeHeight(thisJigsawBlockPos.getX(), thisJigsawBlockPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, state);
                            }
                            l1 = k - nextPieceJigsawBlockY;
                        }
                        int i2 = l1 - nextPieceMinY;
                        BoundingBox nextPieceBoundingBoxPlaced = nextPieceBoundingBox.moved(0, i2, 0);
                        BlockPos blockpos5 = nextPiecePos.offset(0, i2, 0);
                        if (largestSizeOfNextNextPiece > 0) {
                            int j2 = Math.max(largestSizeOfNextNextPiece + 1, nextPieceBoundingBoxPlaced.maxY() - nextPieceBoundingBoxPlaced.minY());
                            nextPieceBoundingBoxPlaced.encapsulate(new BlockPos(nextPieceBoundingBoxPlaced.minX(), nextPieceBoundingBoxPlaced.minY() + j2, nextPieceBoundingBoxPlaced.minZ()));
                        }
                        if (nextPieceCandidate instanceof MowziePoolElement) {
                            Optional<Integer> maxHeight = ((MowziePoolElement)nextPieceCandidate).conditions.maxHeight;
                            Optional<Integer> minHeight = ((MowziePoolElement)nextPieceCandidate).conditions.minHeight;
                            if (maxHeight.isPresent() || minHeight.isPresent()) {
                                int freeHeight = this.chunkGenerator.getFirstFreeHeight(nextPieceBoundingBoxPlaced.minX() + nextPieceBoundingBoxPlaced.getXSpan() / 2, nextPieceBoundingBoxPlaced.minZ() + nextPieceBoundingBoxPlaced.getZSpan() / 2, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, state);
                                if (maxHeight.isPresent() && nextPieceMinY - freeHeight > maxHeight.get() || minHeight.isPresent() && nextPieceMinY - freeHeight < minHeight.get()) continue;
                            }
                        }
                        if (!this.checkBounds(nextPieceCandidate, pieceState, nextPieceBoundingBoxPlaced, nextPiecePos, nextPieceRotation, i2)) continue;
                        if (nextPieceCandidate instanceof MowziePoolElement) {
                            Optional<String> forbiddenOverlapBounds;
                            MowziePoolElement mowziePoolElement2 = (MowziePoolElement)nextPieceCandidate;
                            Optional<String> needsOverlapBounds = mowziePoolElement2.bounds.needsOverlapBounds;
                            if (needsOverlapBounds.isPresent() && (!((Map)this.specialBounds.getValue()).containsKey(needsOverlapBounds.get()) || !Shapes.joinIsNotEmpty((VoxelShape)((VoxelShape)((Map)this.specialBounds.getValue()).get(needsOverlapBounds.get())), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)nextPieceBoundingBoxPlaced).deflate(0.25)), (BooleanOp)BooleanOp.AND)) || (forbiddenOverlapBounds = mowziePoolElement2.bounds.forbiddenOverlapBounds).isPresent() && ((Map)this.specialBounds.getValue()).containsKey(forbiddenOverlapBounds.get()) && Shapes.joinIsNotEmpty((VoxelShape)((VoxelShape)((Map)this.specialBounds.getValue()).get(forbiddenOverlapBounds.get())), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)nextPieceBoundingBoxPlaced).deflate(0.25)), (BooleanOp)BooleanOp.AND)) continue;
                        }
                        int pieceGroundLevelDelta = pieceState.piece.getGroundLevelDelta();
                        int k2 = nextPieceIsRigid ? pieceGroundLevelDelta - k1 : nextPieceCandidate.getGroundLevelDelta();
                        PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(this.structureManager, nextPieceCandidate, blockpos5, k2, nextPieceRotation, nextPieceBoundingBoxPlaced, LiquidSettings.IGNORE_WATERLOGGING);
                        if (thisPieceIsRigid) {
                            l2 = thisPieceMinY + thisPieceHeightFromBottomToJigsawBlock;
                        } else if (nextPieceIsRigid) {
                            l2 = l1 + nextPieceJigsawBlockY;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.getFirstFreeHeight(thisJigsawBlockPos.getX(), thisJigsawBlockPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, state);
                            }
                            l2 = k + k1 / 2;
                        }
                        BoundingBox interiorBounds = null;
                        if (nextPieceCandidate instanceof MowziePoolElement && (interiorBounds = ((MowziePoolElement)nextPieceCandidate).getInteriorBoundingBox(this.structureManager, nextPiecePos, nextPieceRotation)) != null) {
                            interiorBounds = interiorBounds.moved(0, i2, 0);
                        }
                        return new PieceSelection(pieceState, structurepoolelement, nextPieceCandidate, poolelementstructurepiece, thisPieceJigsawBlock, nextPieceJigsawBlock, null, nextPieceBoundingBoxPlaced, interiorBounds, l2);
                    }
                }
            }
            this.fallbacks.add((Pair<StructureTemplate.StructureBlockInfo, PieceState>)new Pair((Object)thisPieceJigsawBlock, (Object)pieceState));
            return null;
        }

        protected boolean checkBounds(StructurePoolElement nextPieceCandidate, PieceState pieceState, BoundingBox nextPieceBoundingBoxPlaced, BlockPos nextPiecePos, Rotation nextPieceRotation, int i2) {
            boolean ignoreBounds = false;
            BoundingBox spaceCheckBounds = nextPieceBoundingBoxPlaced;
            if (nextPieceCandidate instanceof MowziePoolElement) {
                ignoreBounds = ((MowziePoolElement)nextPieceCandidate).ignoresBounds();
                spaceCheckBounds = ((MowziePoolElement)nextPieceCandidate).getCheckBoundingBox(this.structureManager, nextPiecePos, nextPieceRotation).moved(0, i2, 0);
            }
            VoxelShape freeSpace = Shapes.joinUnoptimized((VoxelShape)((VoxelShape)this.free.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)pieceState.piece.getBoundingBox())), (BooleanOp)BooleanOp.OR);
            return ignoreBounds || !Shapes.joinIsNotEmpty((VoxelShape)freeSpace, (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)spaceCheckBounds).deflate(0.25)), (BooleanOp)BooleanOp.ONLY_SECOND);
        }

        void addNextPieceState(PieceSelection pieceSelection) {
            if (!(pieceSelection.nextPiece instanceof MowziePoolElement) || !((MowziePoolElement)pieceSelection.nextPiece).ignoresBounds() && ((MowziePoolElement)pieceSelection.nextPiece).placeBounds()) {
                this.free.setValue((Object)Shapes.joinUnoptimized((VoxelShape)((VoxelShape)this.free.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)pieceSelection.nextPieceBoundingBoxPlaced)), (BooleanOp)BooleanOp.ONLY_FIRST));
            }
            if (pieceSelection.nextPiece instanceof MowziePoolElement && pieceSelection.nextPieceInteriorBoundingBox != null) {
                this.interiorFree.setValue((Object)Shapes.joinUnoptimized((VoxelShape)((VoxelShape)this.interiorFree.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)pieceSelection.nextPieceInteriorBoundingBox)), (BooleanOp)BooleanOp.OR));
            }
            if (pieceSelection.nextPiece instanceof MowziePoolElement) {
                MowziePoolElement mowziePoolElement = (MowziePoolElement)pieceSelection.nextPiece;
                Optional<String> nextPieceSpecialBounds = mowziePoolElement.bounds.specialBounds;
                if (nextPieceSpecialBounds.isPresent()) {
                    if (((Map)this.specialBounds.getValue()).containsKey(nextPieceSpecialBounds.get())) {
                        ((Map)this.specialBounds.getValue()).put(nextPieceSpecialBounds.get(), Shapes.joinUnoptimized((VoxelShape)((VoxelShape)((Map)this.specialBounds.getValue()).get(nextPieceSpecialBounds.get())), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)pieceSelection.nextPieceBoundingBoxPlaced)), (BooleanOp)BooleanOp.OR));
                    } else {
                        ((Map)this.specialBounds.getValue()).put(nextPieceSpecialBounds.get(), Shapes.create((AABB)AABB.of((BoundingBox)pieceSelection.nextPieceBoundingBoxPlaced)));
                    }
                }
            }
            BoundingBox thisPieceBoundingBox = pieceSelection.pieceState.piece.getBoundingBox();
            int thisPieceMinY = thisPieceBoundingBox.minY();
            int thisPieceHeightFromBottomToJigsawBlock = pieceSelection.origJigsaw.pos().getY() - thisPieceMinY;
            int pieceGroundLevelDelta = pieceSelection.pieceState.piece.getGroundLevelDelta();
            int k1 = thisPieceHeightFromBottomToJigsawBlock - pieceSelection.connectedJigsaw.pos().getY() + JigsawBlock.getFrontFacing((BlockState)pieceSelection.origJigsaw.state()).getStepY();
            int k2 = pieceSelection.nextPiece.getProjection() == StructureTemplatePool.Projection.RIGID ? pieceGroundLevelDelta - k1 : pieceSelection.nextPiece.getGroundLevelDelta();
            pieceSelection.pieceState.piece.addJunction(new JigsawJunction(pieceSelection.connectedJigsaw.pos().getX(), pieceSelection.l2 - thisPieceHeightFromBottomToJigsawBlock + pieceGroundLevelDelta, pieceSelection.connectedJigsaw.pos().getZ(), k1, pieceSelection.nextPiece.getProjection()));
            pieceSelection.poolelementstructurepiece.addJunction(new JigsawJunction(pieceSelection.origJigsaw.pos().getX(), pieceSelection.l2 - pieceSelection.connectedJigsaw.pos().getY() + k2, pieceSelection.origJigsaw.pos().getZ(), -k1, pieceSelection.origPiece.getProjection()));
            this.pieces.add((PoolElementStructurePiece)pieceSelection.poolelementstructurepiece);
            String tag = null;
            if (pieceSelection.nextPiece instanceof MowziePoolElement) {
                MowziePoolElement mowziePoolElement = (MowziePoolElement)pieceSelection.nextPiece;
                tag = mowziePoolElement.tags.inheritsTag ? pieceSelection.pieceState.tag : ((MowziePoolElement)pieceSelection.nextPiece).getRandomTag(this.random);
            }
            PieceState nextPieceState = new PieceState(pieceSelection.poolelementstructurepiece, pieceSelection.pieceState.depth + 1, pieceSelection.pieceState, tag);
            List<StructureTemplate.StructureBlockInfo> nextJigsaws = this.getJigsawBlocksFromPieceState(nextPieceState);
            if (!(pieceSelection.poolelementstructurepiece.getElement() instanceof MowziePoolElement) || !((MowziePoolElement)pieceSelection.poolelementstructurepiece.getElement()).twoWay()) {
                nextJigsaws.removeIf(jigsaw -> {
                    Direction direction = JigsawBlock.getFrontFacing((BlockState)pieceSelection.origJigsaw.state());
                    BlockPos thisJigsawBlockPos = pieceSelection.origJigsaw.pos();
                    BlockPos nextJigsawBlockPos = thisJigsawBlockPos.relative(direction);
                    return jigsaw.pos().equals((Object)nextJigsawBlockPos);
                });
            }
            if (pieceSelection.nextPiece instanceof MowziePoolElement && ((MowziePoolElement)pieceSelection.nextPiece).conditions.numPathsOverride.isPresent()) {
                this.numPaths += ((MowziePoolElement)pieceSelection.nextPiece).conditions.numPathsOverride.get().intValue();
            } else {
                for (StructureTemplate.StructureBlockInfo jigsaw2 : nextJigsaws) {
                    if (!jigsaw2.nbt().getString("target").equals(this.pathJigsawName)) continue;
                    ++this.numPaths;
                }
            }
            for (StructureTemplate.StructureBlockInfo jigsaw2 : nextJigsaws) {
                this.placing.add((Pair<StructureTemplate.StructureBlockInfo, PieceState>)new Pair((Object)jigsaw2, (Object)nextPieceState));
            }
            pieceSelection.pieceState.children.add(nextPieceState);
        }
    }

    static final class FallbackPlacer
    extends Placer {
        FallbackPlacer(Registry<StructureTemplatePool> p_210323_, int p_210324_, ChunkGenerator p_210326_, StructureTemplateManager p_210327_, List<? super PoolElementStructurePiece> p_210328_, RandomSource p_210329_, String pathJigsawName, String interiorJigsawName, MutableObject<VoxelShape> free, MutableObject<VoxelShape> interiorFree, MutableObject<Map<String, VoxelShape>> specialBounds, Placer previousPlacer) {
            super(p_210323_, p_210324_, p_210326_, p_210327_, p_210328_, p_210329_, pathJigsawName, interiorJigsawName, free, interiorFree, specialBounds);
            this.placing.addAll(previousPlacer.placing);
            this.placing.addAll(previousPlacer.fallbacks);
            this.interior.addAll(previousPlacer.interior);
            this.numPaths = previousPlacer.numPaths;
        }

        @Override
        List<StructurePoolElement> addPoolElements(PieceState pieceState, StructureTemplatePool pool, StructureTemplatePool fallbackPool) {
            ArrayList structurePoolElements = Lists.newArrayList();
            structurePoolElements.addAll(fallbackPool.getShuffledTemplates(this.random));
            return structurePoolElements;
        }
    }

    static final class InteriorPlacer
    extends Placer {
        InteriorPlacer(Registry<StructureTemplatePool> p_210323_, int p_210324_, ChunkGenerator p_210326_, StructureTemplateManager p_210327_, List<? super PoolElementStructurePiece> p_210328_, RandomSource p_210329_, String pathJigsawName, String interiorJigsawName, MutableObject<VoxelShape> free, MutableObject<VoxelShape> interiorFree, MutableObject<Map<String, VoxelShape>> specialBounds, Placer previousPlacer) {
            super(p_210323_, p_210324_, p_210326_, p_210327_, p_210328_, p_210329_, pathJigsawName, interiorJigsawName, free, interiorFree, specialBounds);
            this.placing.addAll(previousPlacer.interior);
            this.free = interiorFree;
            this.numPaths = previousPlacer.numPaths;
        }

        @Override
        protected boolean skipJigsawBlock(StructureTemplate.StructureBlockInfo thisPieceJigsawBlock, PieceState pieceState) {
            return false;
        }

        @Override
        protected boolean checkBounds(StructurePoolElement nextPieceCandidate, PieceState pieceState, BoundingBox nextPieceBoundingBoxPlaced, BlockPos nextPiecePos, Rotation nextPieceRotation, int i2) {
            boolean ignoreBounds = false;
            BoundingBox spaceCheckBounds = nextPieceBoundingBoxPlaced;
            if (nextPieceCandidate instanceof MowziePoolElement) {
                ignoreBounds = ((MowziePoolElement)nextPieceCandidate).ignoresBounds();
                spaceCheckBounds = ((MowziePoolElement)nextPieceCandidate).getCheckBoundingBox(this.structureManager, nextPiecePos, nextPieceRotation).moved(0, i2, 0);
            }
            return ignoreBounds || !Shapes.joinIsNotEmpty((VoxelShape)((VoxelShape)this.free.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)spaceCheckBounds).deflate(0.25)), (BooleanOp)BooleanOp.ONLY_SECOND);
        }
    }

    public record PieceSelection(PieceState pieceState, StructurePoolElement origPiece, StructurePoolElement nextPiece, PoolElementStructurePiece poolelementstructurepiece, StructureTemplate.StructureBlockInfo origJigsaw, StructureTemplate.StructureBlockInfo connectedJigsaw, StructureTemplate.StructureBlockInfo nextJigsaw, BoundingBox nextPieceBoundingBoxPlaced, BoundingBox nextPieceInteriorBoundingBox, int l2) {
    }

    public static interface PieceFactory {
        public PoolElementStructurePiece create(StructureTemplateManager var1, StructurePoolElement var2, BlockPos var3, int var4, Rotation var5, BoundingBox var6);
    }
}

