/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.ui;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DropdownComponent;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import rearth.oracle.Oracle;
import rearth.oracle.OracleClient;
import rearth.oracle.ui.SearchScreen;
import rearth.oracle.ui.components.ColoredCollapsibleContainer;
import rearth.oracle.ui.components.ScalableLabelComponent;
import rearth.oracle.util.MarkdownParser;

public class OracleScreen
extends BaseOwoScreen<FlowLayout> {
    private FlowLayout navigationBar;
    private FlowLayout contentContainer;
    private FlowLayout rootComponent;
    private FlowLayout leftPanel;
    private ScrollContainer<FlowLayout> outerContentContainer;
    private final Screen parent;
    private boolean needsLayout = false;
    public static ResourceLocation activeEntry;
    public static String activeBook;
    private static final int wideContentWidth = 50;

    public OracleScreen() {
        this.parent = null;
    }

    public OracleScreen(Screen parent) {
        this.parent = parent;
    }

    public void onClose() {
        Objects.requireNonNull(this.minecraft).setScreen(this.parent);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, Containers::horizontalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.blur((float)4.0f, (float)48.0f));
        rootComponent.child(Components.box((Sizing)Sizing.fill(), (Sizing)Sizing.fill()).color(new Color(0.1f, 0.1f, 0.15f, 0.9f)).fill(true).zIndex(-1).positioning(Positioning.absolute((int)0, (int)0)));
        rootComponent.horizontalAlignment(HorizontalAlignment.LEFT);
        rootComponent.verticalAlignment(VerticalAlignment.CENTER);
        this.rootComponent = rootComponent;
        this.leftPanel = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fill());
        this.leftPanel.horizontalAlignment(HorizontalAlignment.CENTER);
        this.navigationBar = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content((int)3));
        this.navigationBar.surface(MarkdownParser.ORACLE_PANEL_DARK);
        this.navigationBar.padding(Insets.of((int)9, (int)5, (int)5, (int)5));
        rootComponent.child((Component)this.leftPanel);
        this.contentContainer = Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content((int)3));
        this.contentContainer.horizontalSizing(Sizing.fill());
        this.contentContainer.horizontalAlignment(HorizontalAlignment.CENTER);
        this.contentContainer.margins(Insets.of((int)2, (int)2, (int)4, (int)4));
        this.contentContainer.padding(Insets.of((int)20, (int)25, (int)0, (int)0));
        this.contentContainer.allowOverflow(true);
        this.outerContentContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)50), (Sizing)Sizing.fill(), (Component)this.contentContainer);
        this.outerContentContainer.allowOverflow(true);
        rootComponent.child(this.outerContentContainer);
        this.buildModNavigation(this.leftPanel);
        ScrollContainer outerNavigationBarContainer = Containers.verticalScroll((Sizing)Sizing.content((int)3), (Sizing)Sizing.fill((int)80), (Component)this.navigationBar);
        this.leftPanel.child((Component)outerNavigationBarContainer);
        FlowLayout searchContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        searchContainer.surface(MarkdownParser.ORACLE_PANEL);
        searchContainer.margins(Insets.of((int)6, (int)6, (int)6, (int)6));
        searchContainer.padding(Insets.of((int)4, (int)6, (int)4, (int)4));
        searchContainer.positioning(Positioning.relative((int)99, (int)99));
        searchContainer.mouseDown().subscribe((mouseX, mouseY, button) -> {
            Minecraft.getInstance().setScreen((Screen)new SearchScreen((Screen)this));
            return true;
        });
        searchContainer.mouseEnter().subscribe(() -> searchContainer.surface(MarkdownParser.ORACLE_PANEL_HOVER));
        searchContainer.mouseLeave().subscribe(() -> searchContainer.surface(MarkdownParser.ORACLE_PANEL));
        ItemComponent searchIcon = Components.item((ItemStack)new ItemStack((ItemLike)Items.SPYGLASS));
        searchIcon.sizing(Sizing.fixed((int)24));
        searchIcon.tooltip((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"tooltip.oracle_index.open_search", (Object[])new Object[]{OracleClient.ORACLE_WIKI.getTranslatedKeyMessage(), OracleClient.ORACLE_SEARCH.getTranslatedKeyMessage()}));
        searchContainer.child((Component)searchIcon);
        rootComponent.child(searchContainer.zIndex(5));
    }

    protected void init() {
        super.init();
        this.updateLayout();
    }

    private void updateLayout() {
        boolean wideEnough;
        int leftOffset = Math.max(15, this.width / 20);
        int leftPanelSize = this.leftPanel.width();
        int leftPanelEnd = this.leftPanel.x() + this.leftPanel.width();
        float innerPanelWideLeft = (float)this.width * 0.5f - (float)(this.width * 50) / 100.0f / 2.0f;
        boolean bl = wideEnough = this.width >= 650;
        if ((float)leftPanelEnd > innerPanelWideLeft + 30.0f) {
            wideEnough = false;
        }
        if (wideEnough) {
            this.rootComponent.horizontalAlignment(HorizontalAlignment.CENTER);
            this.leftPanel.positioning(Positioning.relative((int)0, (int)0));
            this.leftPanel.margins(Insets.of((int)0, (int)0, (int)leftOffset, (int)(leftOffset / 2)));
            this.outerContentContainer.positioning(Positioning.relative((int)60, (int)50));
            this.outerContentContainer.horizontalSizing(Sizing.fill((int)50));
        } else {
            this.rootComponent.horizontalAlignment(HorizontalAlignment.LEFT);
            this.leftPanel.positioning(Positioning.layout());
            this.outerContentContainer.positioning(Positioning.layout());
            this.leftPanel.margins(Insets.of((int)0, (int)0, (int)10, (int)5));
            this.outerContentContainer.horizontalSizing(Sizing.fixed((int)(this.width - leftPanelSize - 20)));
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        if (this.needsLayout) {
            this.needsLayout = false;
            this.updateLayout();
        }
        if (Screen.hasControlDown()) {
            Oracle.LOGGER.info("Opening Oracle Search...");
            Objects.requireNonNull(this.minecraft).setScreen((Screen)new SearchScreen((Screen)this));
        }
    }

    private void loadContentContainer(ResourceLocation filePath, String bookId) throws IOException {
        ResourceManager resourceManager;
        Optional resourceCandidate;
        this.contentContainer.clearChildren();
        activeEntry = filePath;
        Optional<ResourceLocation> translatedPath = OracleClient.getTranslatedPath(filePath, bookId);
        if (translatedPath.isPresent()) {
            filePath = translatedPath.get();
        }
        if ((resourceCandidate = (resourceManager = Minecraft.getInstance().getResourceManager()).getResource(filePath)).isEmpty()) {
            System.out.println("No content file found for " + String.valueOf(filePath));
            return;
        }
        String fileContent = new String(((Resource)resourceCandidate.get()).open().readAllBytes(), StandardCharsets.UTF_8);
        ResourceLocation finalFilePath = filePath;
        List<Component> parsedTexts = MarkdownParser.parseMarkdownToOwoComponents(fileContent, bookId, link -> {
            if (link.startsWith("http")) {
                return false;
            }
            String[] pathSegments = finalFilePath.getPath().split("/");
            Object newPath = "";
            int parentIteration = link.startsWith("../") ? 1 : 0;
            for (int i = 0; i < pathSegments.length - 1 - parentIteration; ++i) {
                newPath = (String)newPath + pathSegments[i] + "/";
            }
            newPath = ((String)newPath).split("#")[0];
            newPath = (String)newPath + link.replace("../", "") + ".mdx";
            ResourceLocation newId = ResourceLocation.fromNamespaceAndPath((String)"oracle_index", (String)newPath);
            try {
                this.loadContentContainer(newId, bookId);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        });
        for (Component paragraph : parsedTexts) {
            if (paragraph instanceof LabelComponent) {
                paragraph.horizontalSizing(Sizing.fill());
            } else if (paragraph instanceof TextureComponent) {
                TextureComponent textureComponent = (TextureComponent)paragraph;
                ratio = (float)((PositionedRectangle)textureComponent.visibleArea().get()).width() / (float)((PositionedRectangle)textureComponent.visibleArea().get()).height();
                targetSize = (float)((Sizing)textureComponent.verticalSizing().get()).value / 100.0f;
                maxWidth = (float)this.width * 0.6f;
                usedWidth = maxWidth * targetSize * 0.8f;
                height = usedWidth / ratio;
                textureComponent.sizing(Sizing.fixed((int)((int)usedWidth)), Sizing.fixed((int)((int)height)));
            } else if (paragraph instanceof ItemComponent) {
                ItemComponent itemComponent = (ItemComponent)paragraph;
                ratio = 1.0f;
                targetSize = (float)((Sizing)itemComponent.verticalSizing().get()).value / 100.0f;
                maxWidth = (float)this.width * 0.6f;
                usedWidth = maxWidth * targetSize * 0.8f;
                height = usedWidth / ratio;
                itemComponent.sizing(Sizing.fixed((int)((int)usedWidth)), Sizing.fixed((int)((int)height)));
            }
            if (((Insets)paragraph.margins().get()).equals((Object)Insets.of((int)0))) {
                paragraph.margins(Insets.of((int)4, (int)1, (int)0, (int)0));
            }
            this.contentContainer.child(paragraph);
        }
    }

    private void buildModNavigation(FlowLayout buttonContainer) {
        List bookIds = OracleClient.LOADED_BOOKS.stream().sorted().toList();
        DropdownComponent modSelectorDropdown = Components.dropdown((Sizing)Sizing.content((int)3));
        modSelectorDropdown.zIndex(5);
        if (activeBook == null) {
            activeBook = (String)bookIds.getFirst();
        }
        if (activeEntry != null) {
            try {
                this.loadContentContainer(activeEntry, activeBook);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        int topMargins = 40;
        if (this.height < 350) {
            topMargins = 5;
        }
        ScalableLabelComponent bookTitleLabel = new ScalableLabelComponent((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)("oracle_index.title." + activeBook)).withStyle(ChatFormatting.DARK_GRAY).append(" >").withStyle(ChatFormatting.DARK_GRAY), text -> false);
        bookTitleLabel.scale = 1.5f;
        FlowLayout bookTitleWrapper = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        bookTitleWrapper.surface(MarkdownParser.ORACLE_PANEL);
        bookTitleWrapper.padding(Insets.of((int)8));
        bookTitleWrapper.margins(Insets.of((int)topMargins, (int)-7, (int)0, (int)0));
        bookTitleWrapper.child((Component)bookTitleLabel);
        buttonContainer.child(bookTitleWrapper.zIndex(5));
        bookTitleWrapper.mouseEnter().subscribe(() -> bookTitleWrapper.surface(MarkdownParser.ORACLE_PANEL_HOVER));
        bookTitleWrapper.mouseLeave().subscribe(() -> bookTitleWrapper.surface(MarkdownParser.ORACLE_PANEL));
        bookTitleWrapper.mouseDown().subscribe((a, b, c) -> {
            if (modSelectorDropdown.hasParent()) {
                modSelectorDropdown.remove();
                return true;
            }
            this.rootComponent.child((Component)modSelectorDropdown.positioning(Positioning.absolute((int)(bookTitleWrapper.x() + bookTitleWrapper.width()), (int)bookTitleWrapper.y())));
            return true;
        });
        for (String bookId : bookIds) {
            modSelectorDropdown.button((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)("oracle_index.title." + bookId)), elem -> {
                activeEntry = null;
                modSelectorDropdown.remove();
                this.buildModNavigationBar(bookId);
                bookTitleLabel.text((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)("oracle_index.title." + bookId)).withStyle(ChatFormatting.DARK_GRAY).append(" >").withStyle(ChatFormatting.DARK_GRAY));
                activeBook = bookId;
            });
        }
        this.buildModNavigationBar(activeBook);
    }

    private void buildModNavigationBar(String bookId) {
        this.navigationBar.clearChildren();
        this.buildNavigationEntriesForModPath(bookId, "", this.navigationBar);
    }

    private void buildNavigationEntriesForModPath(String bookId, String path, FlowLayout container) {
        Optional resourceCandidate;
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        ResourceLocation metaPath = ResourceLocation.fromNamespaceAndPath((String)"oracle_index", (String)("books/" + bookId + path + "/_meta.json"));
        Optional<ResourceLocation> translatedMetaPath = OracleClient.getTranslatedPath(metaPath, bookId);
        if (translatedMetaPath.isPresent()) {
            metaPath = translatedMetaPath.get();
        }
        if ((resourceCandidate = resourceManager.getResource(metaPath)).isEmpty()) {
            System.out.println("No _meta.json found for " + bookId + " at " + String.valueOf(metaPath));
            return;
        }
        try {
            Optional<MetaJsonEntry> firstEntry;
            String metaFile = new String(((Resource)resourceCandidate.get()).open().readAllBytes(), StandardCharsets.UTF_8);
            List<MetaJsonEntry> entries = OracleScreen.parseJson(metaFile);
            if (activeEntry == null && (firstEntry = entries.stream().filter(elem -> !elem.directory).findFirst()).isPresent()) {
                ResourceLocation firstEntryPath = ResourceLocation.fromNamespaceAndPath((String)"oracle_index", (String)("books/" + bookId + path + "/" + firstEntry.get().id()));
                this.loadContentContainer(firstEntryPath, bookId);
                activeEntry = firstEntryPath;
            }
            ArrayList<ColoredCollapsibleContainer> levelContainers = new ArrayList<ColoredCollapsibleContainer>();
            for (MetaJsonEntry entry : entries) {
                if (entry.directory) {
                    ColoredCollapsibleContainer directoryContainer = new ColoredCollapsibleContainer(Sizing.content((int)1), Sizing.content((int)1), (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)entry.name()).withStyle(ChatFormatting.WHITE), false);
                    this.buildNavigationEntriesForModPath(bookId, path + "/" + entry.id(), (FlowLayout)directoryContainer);
                    directoryContainer.margins(Insets.of((int)0, (int)0, (int)0, (int)0));
                    container.child((Component)directoryContainer);
                    directoryContainer.mouseDown().subscribe((a, b, c) -> {
                        for (ColoredCollapsibleContainer elem : levelContainers) {
                            if (elem == directoryContainer || !elem.expanded()) continue;
                            elem.toggleExpansion();
                        }
                        this.needsLayout = true;
                        return false;
                    });
                    levelContainers.add(directoryContainer);
                    continue;
                }
                ResourceLocation labelPath = ResourceLocation.fromNamespaceAndPath((String)"oracle_index", (String)("books/" + bookId + path + "/" + entry.id()));
                MutableComponent labelText = net.minecraft.network.chat.Component.translatable((String)entry.name).withStyle(ChatFormatting.WHITE);
                LabelComponent label = Components.label((net.minecraft.network.chat.Component)labelText.withStyle(ChatFormatting.UNDERLINE));
                label.mouseEnter().subscribe(() -> label.text((net.minecraft.network.chat.Component)labelText.copy().withStyle(ChatFormatting.GRAY)));
                label.mouseLeave().subscribe(() -> label.text((net.minecraft.network.chat.Component)labelText.copy()));
                label.mouseDown().subscribe((a, b, c) -> {
                    try {
                        this.loadContentContainer(labelPath, bookId);
                        return true;
                    }
                    catch (IOException e) {
                        Oracle.LOGGER.error(e.getMessage());
                        return false;
                    }
                });
                label.margins(Insets.of((int)3, (int)2, (int)5, (int)2));
                container.child((Component)label);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<MetaJsonEntry> parseJson(String jsonString) {
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
        ArrayList<MetaJsonEntry> entries = new ArrayList<MetaJsonEntry>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            boolean directory;
            String id = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            boolean bl = directory = !id.endsWith(".mdx");
            String name = value instanceof JsonPrimitive ? value.getAsString() : (value instanceof JsonObject ? ((JsonObject)value).get("name").getAsString() : "Unknown Name");
            entries.add(new MetaJsonEntry(id, name, directory));
        }
        return entries;
    }

    public record MetaJsonEntry(String id, String name, boolean directory) {
        @Override
        public String toString() {
            return "MetaJsonEntry{id='" + this.id + "', name='" + this.name + "', directory=" + this.directory + "}";
        }
    }
}

