/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.ui;

import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.ValidationResult;
import org.jetbrains.annotations.NotNull;
import rearth.oracle.Oracle;
import rearth.oracle.OracleClient;
import rearth.oracle.SemanticSearch;
import rearth.oracle.ui.components.ScalableLabelComponent;
import rearth.oracle.util.MarkdownParser;

public class SearchScreen
extends BaseOwoScreen<FlowLayout> {
    private FlowLayout resultsPanel;
    private int waitFrames = 0;
    private final Screen parent;
    private static final String MATH_EXPR_REGEX = "^[\\d\\s+\\-*/%().]+$";
    private TextBoxComponent searchBar;

    public SearchScreen(Screen parent) {
        this.parent = parent;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.blur((float)4.0f, (float)24.0f));
        rootComponent.child(Components.box((Sizing)Sizing.fill(), (Sizing)Sizing.fill()).color(new Color(0.1f, 0.1f, 0.15f, 0.6f)).fill(true).zIndex(-1).positioning(Positioning.absolute((int)0, (int)0)));
        rootComponent.horizontalAlignment(HorizontalAlignment.CENTER);
        rootComponent.verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout mainContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)350), (Sizing)Sizing.fill((int)99));
        rootComponent.child((io.wispforest.owo.ui.core.Component)mainContainer);
        FlowLayout searchPanel = Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content((int)2));
        searchPanel.margins(Insets.of((int)16, (int)-2, (int)0, (int)0));
        TextureComponent oracleIcon = Components.texture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"oracle_index", (String)"textures/oracle-index-icon.png"), (int)0, (int)0, (int)256, (int)256, (int)256, (int)256);
        oracleIcon.sizing(Sizing.fixed((int)50));
        oracleIcon.zIndex(2);
        searchPanel.child((io.wispforest.owo.ui.core.Component)oracleIcon);
        this.searchBar = Components.textBox((Sizing)Sizing.fixed((int)296), (String)"");
        this.searchBar.onChanged().subscribe(this::onSearchTyped);
        this.searchBar.tooltip((Component)Component.translatable((String)"oracle_index.searchbar.tooltip"));
        this.searchBar.setSuggestion(Component.translatable((String)"oracle_index.searchbar.placeholder").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}).getString());
        this.searchBar.setEditable(false);
        FlowLayout searchTextContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        searchTextContainer.surface(MarkdownParser.ORACLE_PANEL);
        searchTextContainer.padding(Insets.of((int)3, (int)5, (int)22, (int)3));
        searchTextContainer.margins(Insets.of((int)4, (int)0, (int)-25, (int)0));
        searchTextContainer.child((io.wispforest.owo.ui.core.Component)this.searchBar);
        searchPanel.child((io.wispforest.owo.ui.core.Component)searchTextContainer);
        mainContainer.child((io.wispforest.owo.ui.core.Component)searchPanel);
        this.resultsPanel = Containers.verticalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content((int)3));
        ScrollContainer outerContainer = Containers.verticalScroll((Sizing)Sizing.fill(), (Sizing)Sizing.fill((int)80), (io.wispforest.owo.ui.core.Component)this.resultsPanel);
        mainContainer.child((io.wispforest.owo.ui.core.Component)outerContainer);
    }

    protected void init() {
        super.init();
        ((FlowLayout)this.uiAdapter.rootComponent).focusHandler().focus((io.wispforest.owo.ui.core.Component)this.searchBar, Component.FocusSource.MOUSE_CLICK);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        boolean searchReady = false;
        try {
            searchReady = OracleClient.getOrCreateSearch().isReady();
        }
        catch (Throwable error) {
            error.printStackTrace();
            Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"Sorry, Oracle Index Search is not available on your platform."));
            Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"If you want this search feature, you can use the xplat jar available on the mods github."));
            Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"https://github.com/Rearth/Oracle-Index - The jars are available in the 'releases' section."));
            Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"This is not the default file due to jar size limitations."));
            this.onClose();
            return;
        }
        if (searchReady) {
            this.searchBar.setEditable(true);
            if (this.searchBar.getValue().startsWith("Indexing")) {
                this.searchBar.setValue("");
                Oracle.LOGGER.info("Embeddings took {}ms across all threads.", (Object)(OracleClient.getOrCreateSearch().getEmbeddingTime() / 1000000L));
            }
        } else {
            ++this.waitFrames;
            int dots = this.waitFrames / 2 % 3 + 1;
            this.searchBar.setEditable(false);
            this.searchBar.setValue("Indexing" + ".".repeat(dots));
            this.searchBar.setSuggestion("");
        }
    }

    private void onSearchTyped(String query) {
        if (query.startsWith("Indexing")) {
            return;
        }
        String usedPlaceholder = Component.translatable((String)"oracle_index.searchbar.placeholder").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}).getString();
        if (!query.isEmpty()) {
            usedPlaceholder = "";
        }
        this.searchBar.setSuggestion(usedPlaceholder);
        if (query.length() <= 2) {
            return;
        }
        Optional<SemanticSearch.SearchResult> expressionResult = this.tryProcessExpression(query);
        if (expressionResult.isEmpty() && query.matches(MATH_EXPR_REGEX)) {
            return;
        }
        this.resultsPanel.clearChildren();
        List<SemanticSearch.SearchResult> results = expressionResult.isPresent() ? List.of(expressionResult.get()) : OracleClient.getOrCreateSearch().search(query);
        for (SemanticSearch.SearchResult result : results) {
            FlowLayout resultTitlePanel = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            resultTitlePanel.surface(MarkdownParser.ORACLE_PANEL_DARK);
            resultTitlePanel.margins(Insets.of((int)2, (int)2, (int)1, (int)5));
            resultTitlePanel.padding(Insets.of((int)6, (int)7, (int)6, (int)8));
            resultTitlePanel.zIndex(2);
            if (result.iconName() != null && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)result.iconName()))) {
                ItemStack itemDisplay = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)result.iconName())));
                ItemComponent itemComponent = Components.item((ItemStack)itemDisplay);
                itemComponent.sizing(Sizing.fixed((int)14));
                itemComponent.margins(Insets.of((int)-3, (int)-2, (int)-2, (int)4));
                resultTitlePanel.allowOverflow(true);
                resultTitlePanel.child((io.wispforest.owo.ui.core.Component)itemComponent);
            }
            MutableComponent titleText = Component.literal((String)result.title());
            LabelComponent title = Components.label((Component)titleText.withStyle(ChatFormatting.BOLD));
            resultTitlePanel.child((io.wispforest.owo.ui.core.Component)title);
            FlowLayout resultTextPanel = Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content());
            resultTextPanel.surface(MarkdownParser.ORACLE_PANEL);
            resultTextPanel.margins(Insets.of((int)-5, (int)2, (int)10, (int)5));
            resultTextPanel.padding(Insets.of((int)7, (int)8, (int)4, (int)4));
            for (String text : result.texts()) {
                List<io.wispforest.owo.ui.core.Component> paragraphs = MarkdownParser.parseMarkdownToOwoComponents(text, result.id().getNamespace(), string -> false);
                io.wispforest.owo.ui.core.Component component = paragraphs.getFirst();
                if (component instanceof BaseParentComponent) {
                    BaseParentComponent parentComponent = (BaseParentComponent)component;
                    paragraphs.addAll(parentComponent.children());
                }
                boolean hadContent = false;
                for (io.wispforest.owo.ui.core.Component paragraph : paragraphs) {
                    if (!(paragraph instanceof ScalableLabelComponent)) continue;
                    ScalableLabelComponent labelComponent = (ScalableLabelComponent)paragraph;
                    if (labelComponent.scale != 1.0f) continue;
                    paragraph.horizontalSizing(Sizing.fill());
                    paragraph.margins(Insets.of((int)0));
                    labelComponent.lineSpacing(0);
                    resultTextPanel.child(paragraph);
                    labelComponent.text((Component)labelComponent.text().copy().withStyle(ChatFormatting.DARK_GRAY));
                    hadContent = true;
                }
                if (!hadContent) continue;
                break;
            }
            this.resultsPanel.child((io.wispforest.owo.ui.core.Component)resultTitlePanel);
            if (!resultTextPanel.children().isEmpty()) {
                this.resultsPanel.child((io.wispforest.owo.ui.core.Component)resultTextPanel);
            }
            resultTextPanel.mouseEnter().subscribe(() -> resultTextPanel.surface(MarkdownParser.ORACLE_PANEL_HOVER));
            resultTextPanel.mouseLeave().subscribe(() -> resultTextPanel.surface(MarkdownParser.ORACLE_PANEL));
            resultTitlePanel.mouseEnter().subscribe(() -> resultTitlePanel.surface(MarkdownParser.ORACLE_PANEL_PRESSED));
            resultTitlePanel.mouseLeave().subscribe(() -> resultTitlePanel.surface(MarkdownParser.ORACLE_PANEL_DARK));
            resultTitlePanel.mouseDown().subscribe((mouseX, mouseY, button) -> {
                ResourceLocation contentId = ResourceLocation.fromNamespaceAndPath((String)"oracle_index", (String)String.format("books/%s/%s", result.id().getNamespace(), result.id().getPath()));
                OracleClient.openScreen(result.id().getNamespace(), contentId, (Screen)this);
                return true;
            });
            resultTextPanel.mouseDown().subscribe((mouseX, mouseY, button) -> {
                ResourceLocation contentId = ResourceLocation.fromNamespaceAndPath((String)"oracle_index", (String)String.format("books/%s/%s", result.id().getNamespace(), result.id().getPath()));
                OracleClient.openScreen(result.id().getNamespace(), contentId, (Screen)this);
                return true;
            });
        }
    }

    private Optional<SemanticSearch.SearchResult> tryProcessExpression(String input) {
        try {
            Expression expression = new ExpressionBuilder(input).build();
            ValidationResult valid = expression.validate();
            if (valid.isValid()) {
                double resultingNumber = expression.evaluate();
                String calculationText = String.format("%s = **%s**", input.replace("*", "x"), new DecimalFormat("#.####").format(resultingNumber));
                SemanticSearch.SearchResult res = new SemanticSearch.SearchResult(List.of(calculationText), 1.0, "Calculation: ", ResourceLocation.fromNamespaceAndPath((String)"oracle_index", (String)"expression"), "minecraft:comparator");
                return Optional.of(res);
            }
            return Optional.empty();
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    public void onClose() {
        Objects.requireNonNull(this.minecraft).setScreen(this.parent);
    }
}

