/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public interface IProgressTracker {
    public Task subtask(int var1);

    public static Tree createTree(int totalSteps) {
        return new Tree(totalSteps);
    }

    public static final class Tree
    implements Task {
        private volatile List<Tree> subtasks = List.of();
        private final int totalSteps;
        private final AtomicInteger completedSteps = new AtomicInteger(0);

        public Tree(int totalSteps) {
            this.totalSteps = totalSteps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Task subtask(int totalSteps) {
            Tree child = new Tree(totalSteps);
            Tree tree = this;
            synchronized (tree) {
                ArrayList<Tree> next = new ArrayList<Tree>(this.subtasks);
                next.add(child);
                this.subtasks = Collections.unmodifiableList(next);
            }
            return child;
        }

        @Override
        public void step() {
            int next;
            int prev;
            do {
                if ((prev = this.completedSteps.get()) < this.totalSteps) continue;
                return;
            } while (!this.completedSteps.compareAndSet(prev, next = prev + 1));
        }

        public float getProgress() {
            if (this.totalSteps == 0) {
                return 1.0f;
            }
            List<Tree> snapshot = this.subtasks;
            int localCompleted = this.completedSteps.get();
            if (snapshot.isEmpty()) {
                return (float)localCompleted / (float)this.totalSteps;
            }
            float sum = 0.0f;
            for (Tree sub : snapshot) {
                sum += sub.getProgress();
            }
            return sum / (float)snapshot.size();
        }

        public int countLeaves() {
            List<Tree> snapshot = this.subtasks;
            if (snapshot.isEmpty()) {
                return 1;
            }
            int sum = 0;
            for (Tree sub : snapshot) {
                sum += sub.countLeaves();
            }
            return sum;
        }
    }

    public static interface Task
    extends IProgressTracker {
        public void step();
    }
}

