/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.mojang.datafixers.util.Either;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class TileOrEntityTarget {
    private final Either<BlockPos, Integer> posOrEntityId;

    private TileOrEntityTarget(Either<BlockPos, Integer> either) {
        this.posOrEntityId = either;
    }

    public static TileOrEntityTarget orThrow(Object object) {
        if (object instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)object;
            return TileOrEntityTarget.of(be);
        }
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            return TileOrEntityTarget.of(entity);
        }
        throw new IllegalArgumentException("Object must be a BlockEntity or Entity");
    }

    public static TileOrEntityTarget of(BlockEntity be) {
        return new TileOrEntityTarget((Either<BlockPos, Integer>)Either.left((Object)be.getBlockPos()));
    }

    public static TileOrEntityTarget of(Entity entity) {
        return new TileOrEntityTarget((Either<BlockPos, Integer>)Either.right((Object)entity.getId()));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.posOrEntityId.left().isPresent());
        if (this.posOrEntityId.left().isPresent()) {
            buf.writeBlockPos((BlockPos)this.posOrEntityId.left().get());
        } else {
            buf.writeVarInt(((Integer)this.posOrEntityId.right().get()).intValue());
        }
    }

    public static TileOrEntityTarget read(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            return new TileOrEntityTarget((Either<BlockPos, Integer>)Either.left((Object)buf.readBlockPos()));
        }
        return new TileOrEntityTarget((Either<BlockPos, Integer>)Either.right((Object)buf.readVarInt()));
    }

    @Nullable
    public Object getTarget(Level level) {
        if (this.posOrEntityId.left().isPresent()) {
            BlockPos pos = (BlockPos)this.posOrEntityId.left().get();
            BlockEntity be = level.getBlockEntity(pos);
            if (be != null) {
                return be;
            }
            return level.getBlockState(pos);
        }
        return level.getEntity(((Integer)this.posOrEntityId.right().get()).intValue());
    }

    public <T extends BlockEntity> T getBlockEntityOrThrow(Level level, BlockEntityType<T> type) {
        BlockEntity be;
        if (this.posOrEntityId.left().isPresent() && (be = type.getBlockEntity((BlockGetter)level, (BlockPos)this.posOrEntityId.left().get())) != null) {
            return (T)be;
        }
        throw new IllegalStateException("No BlockEntity found at " + String.valueOf(this.posOrEntityId.left().orElse(null)));
    }

    public <T extends Entity> T getEntityOrThrow(Level level, EntityType<T> type) {
        Entity entity;
        if (this.posOrEntityId.right().isPresent() && (entity = level.getEntity(((Integer)this.posOrEntityId.right().get()).intValue())) != null && entity.getType() == type) {
            return (T)entity;
        }
        throw new IllegalStateException("No Entity found with ID " + String.valueOf(this.posOrEntityId.right().orElse(null)));
    }

    @Nullable
    public <T> T map(Level level, Function<BlockEntity, T> a, Function<Entity, T> b) {
        if (this.posOrEntityId.left().isPresent()) {
            BlockEntity be = level.getBlockEntity((BlockPos)this.posOrEntityId.left().get());
            if (be != null) {
                return a.apply(be);
            }
        } else {
            Entity entity = level.getEntity(((Integer)this.posOrEntityId.right().get()).intValue());
            if (entity != null) {
                return b.apply(entity);
            }
        }
        return null;
    }

    @Nullable
    public BlockPos getPos() {
        return this.posOrEntityId.left().orElse(null);
    }

    @Nullable
    public Integer getEntityId() {
        return this.posOrEntityId.right().orElse(null);
    }

    public String toString() {
        return "TileOrEntityTarget{posOrEntityId=" + String.valueOf(this.posOrEntityId) + "}";
    }
}

