/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedData;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public final class WorldSavedDataType<D extends WorldSavedData> {
    public static final StreamCodec<RegistryFriendlyByteBuf, WorldSavedDataType<? extends WorldSavedData>> STREAM_CODEC = ByteBufCodecs.registry((ResourceKey)MoonlightRegistry.WORLD_SAVED_DATA_TYPE_REGISTRY.key());
    public static final Codec<WorldSavedDataType<? extends WorldSavedData>> CODEC = MoonlightRegistry.WORLD_SAVED_DATA_TYPE_REGISTRY.byNameCodec();
    private final Codec<D> codec;
    @Nullable
    private final StreamCodec<? super RegistryFriendlyByteBuf, D> streamCodec;
    private final SavedData.Factory<D> factory;
    private final String name;
    private final Scope scope;
    private D clientInstance = null;

    public WorldSavedDataType(ResourceLocation id, Function<ServerLevel, D> overworldToDataConstructor, Codec<D> codec, @Nullable StreamCodec<? super RegistryFriendlyByteBuf, D> streamCodec) {
        this(id, overworldToDataConstructor, codec, streamCodec, Scope.SINGLE_OVERWORLD);
    }

    public WorldSavedDataType(ResourceLocation id, Function<ServerLevel, D> overworldToDataConstructor, Codec<D> codec, @Nullable StreamCodec<? super RegistryFriendlyByteBuf, D> streamCodec, Scope scope) {
        this.codec = codec;
        this.streamCodec = streamCodec;
        this.name = id.toDebugFileName();
        this.scope = scope;
        this.factory = new SavedData.Factory(() -> (WorldSavedData)((Object)((Object)overworldToDataConstructor.apply(PlatHelper.getCurrentServer().overworld()))), this::load, null);
    }

    @Nullable
    public D getData(Level level) {
        if (level.isClientSide && !this.isSyncable()) {
            throw new IllegalStateException("Tried to access unsyncable world saved data on client side!");
        }
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ServerLevel targetLevel = this.scope.getTargetLevel(server);
            return (D)((Object)((WorldSavedData)targetLevel.getDataStorage().computeIfAbsent(this.factory, this.name)));
        }
        return this.clientInstance;
    }

    public void setData(Level level, D data) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ServerLevel targetLevel = this.scope.getTargetLevel(server);
            targetLevel.getDataStorage().set(this.name, data);
        } else {
            this.clientInstance = data;
        }
        ((WorldSavedData)((Object)data)).onReassigned(level);
    }

    private D load(CompoundTag tag, HolderLookup.Provider provider) {
        Tag t = tag.get(this.getName());
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        DataResult dataResult = this.codec.decode((DynamicOps)ops, (Object)t);
        return (D)((Object)((WorldSavedData)((Object)((Pair)dataResult.getOrThrow()).getFirst())));
    }

    public Codec<D> getCodec() {
        return this.codec;
    }

    @Nullable
    public StreamCodec<? super RegistryFriendlyByteBuf, D> getStreamCodec() {
        return this.streamCodec;
    }

    public boolean isSyncable() {
        return this.streamCodec != null;
    }

    public String getName() {
        return this.name;
    }

    public static enum Scope {
        SINGLE_OVERWORLD,
        PER_LEVEL;


        private ServerLevel getTargetLevel(ServerLevel sl) {
            ServerLevel targetLevel = this == PER_LEVEL ? sl : sl.getServer().overworld();
            return targetLevel;
        }
    }
}

