/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Rotation;

public interface Sampler2D {
    public int sample(float var1, float var2);

    public static Sampler2D nearest(Sampler2D base) {
        return (x, y) -> base.sample(Math.round(x), Math.round(y));
    }

    public static Sampler2D bilinear(Sampler2D base) {
        return (x, y) -> {
            int x0 = (int)x;
            int y0 = (int)y;
            if ((float)x0 == x && (float)y0 == y) {
                return base.sample(x0, y0);
            }
            int x1 = x0 + 1;
            int y1 = y0 + 1;
            float dx = x - (float)x0;
            float dy = y - (float)y0;
            int c00 = base.sample(x0, y0);
            int c10 = base.sample(x1, y0);
            int c01 = base.sample(x0, y1);
            int c11 = base.sample(x1, y1);
            int top = ColorUtils.lerp(c00, c10, dx);
            int bottom = ColorUtils.lerp(c01, c11, dx);
            return ColorUtils.lerp(top, bottom, dy);
        };
    }

    public static Sampler2D paletted(Sampler2D base, Palette palette) {
        return (x, y) -> {
            int color = base.sample(x, y);
            return palette.getColorClosestTo(new PaletteColor(color)).value();
        };
    }

    public static Sampler2D offset(Sampler2D base, float ox, float oy) {
        return (x, y) -> base.sample(x + ox, y + oy);
    }

    public static Sampler2D scale(Sampler2D base, float sx, float sy) {
        return (x, y) -> base.sample(x * sx, y * sy);
    }

    public static Sampler2D rotate(Sampler2D base, Rotation rotation, int width, int height) {
        return switch (rotation) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> base;
            case Rotation.CLOCKWISE_90 -> (x, y) -> base.sample(y, (float)width - x);
            case Rotation.CLOCKWISE_180 -> (x, y) -> base.sample((float)width - x, (float)height - y);
            case Rotation.COUNTERCLOCKWISE_90 -> (x, y) -> base.sample((float)height - y, x);
        };
    }

    public static Sampler2D flippedX(Sampler2D base, int width) {
        return (x, y) -> base.sample((float)width - x, y);
    }

    public static Sampler2D flippedY(Sampler2D base, int height) {
        return (x, y) -> base.sample(x, (float)height - y);
    }

    public static Sampler2D clamp(Sampler2D base, int width, int height) {
        return (x, y) -> {
            int ix = (int)Mth.clamp((float)x, (float)0.0f, (float)width);
            int iy = (int)Mth.clamp((float)y, (float)0.0f, (float)height);
            return base.sample(ix, iy);
        };
    }

    public static Sampler2D wrap(Sampler2D base, int width, int height) {
        return (x, y) -> {
            int ix = ((int)Math.floor(x) % width + width) % width;
            int iy = ((int)Math.floor(y) % height + height) % height;
            return base.sample(ix, iy);
        };
    }
}

