/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Sampler2D;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.Nullable;

public class TextureCollager {
    protected final int originFrameW;
    protected final int originFrameH;
    protected final int targetFrameW;
    protected final int targetFrameH;
    private final List<Operation> operations;

    public void apply(TextureImage source, TextureImage destination) {
        float scaleSourceX = (float)source.frameWidth() / (float)this.originFrameW;
        float scaleSourceY = (float)source.frameHeight() / (float)this.originFrameH;
        float scaleTargetX = (float)destination.frameWidth() / (float)this.targetFrameW;
        float scaleTargetY = (float)destination.frameHeight() / (float)this.targetFrameH;
        int sourceFrames = source.frameCount();
        int targetFrames = destination.frameCount();
        int maxFrames = Math.max(sourceFrames, targetFrames);
        for (int i = 0; i < maxFrames; ++i) {
            int cappedSourceFrame = Math.min(i, sourceFrames - 1);
            int cappedTargetFrame = Math.min(i, targetFrames - 1);
            Sampler2D sourceFrameSampler = source.frameSampler(cappedSourceFrame);
            sourceFrameSampler = Sampler2D.scale(sourceFrameSampler, scaleSourceX, scaleSourceY);
            for (Operation op : this.operations) {
                Sampler2D sampler = op.makeSampler(sourceFrameSampler);
                for (int ty = 0; ty < op.targetH; ++ty) {
                    for (int tx = 0; tx < op.targetW; ++tx) {
                        int color = sampler.sample(tx, ty);
                        if (op.palettes != null) {
                            int maxPaletteIndex = Math.min(source.frameCount(), op.palettes.size());
                            color = op.palettes.get(maxPaletteIndex).getColorClosestTo(new PaletteColor(color)).value();
                        }
                        if (op.blended) {
                            destination.blendFramePixel(cappedTargetFrame, (int)((float)(op.targetX + tx) * scaleTargetX), (int)((float)(op.targetY + ty) * scaleTargetY), color);
                            continue;
                        }
                        destination.setFramePixel(cappedTargetFrame, (int)((float)(op.targetX + tx) * scaleTargetX), (int)((float)(op.targetY + ty) * scaleTargetY), color);
                    }
                }
            }
        }
    }

    private TextureCollager(int originalW, int originalH, int targetW, int targetH, List<Operation> list) {
        this.originFrameW = originalW;
        this.originFrameH = originalH;
        this.targetFrameW = targetW;
        this.targetFrameH = targetH;
        this.operations = list;
    }

    public static Builder builder(int originFrameW, int originFrameH, int targetFrameW, int targetFrameH) {
        return new Builder(originFrameW, originFrameH, targetFrameW, targetFrameH);
    }

    private record Operation(int sourceX, int sourceY, int sourceW, int sourceH, int targetX, int targetY, int targetW, int targetH, boolean flipX, boolean flipY, Rotation rotation, boolean bilinear, boolean blended, @Nullable List<Palette> palettes) {
        private Sampler2D makeSampler(Sampler2D sampler) {
            sampler = Sampler2D.offset(sampler, this.sourceX, this.sourceY);
            if (this.bilinear) {
                sampler = Sampler2D.bilinear(sampler);
            }
            sampler = Sampler2D.offset(sampler, -0.5f, -0.5f);
            if (this.flipX) {
                int w = this.rotation == Rotation.CLOCKWISE_90 || this.rotation == Rotation.COUNTERCLOCKWISE_90 ? this.sourceH : this.sourceW;
                sampler = Sampler2D.flippedX(sampler, w);
            }
            if (this.flipY) {
                int h = this.rotation == Rotation.CLOCKWISE_90 || this.rotation == Rotation.COUNTERCLOCKWISE_90 ? this.sourceW : this.sourceH;
                sampler = Sampler2D.flippedY(sampler, h);
            }
            if (this.rotation != Rotation.NONE) {
                sampler = Sampler2D.rotate(sampler, this.rotation, this.sourceW, this.sourceH);
            }
            sampler = Sampler2D.offset(sampler, 0.5f, 0.5f);
            float opScaleW = (float)this.sourceW / (float)this.targetW;
            float opScaleH = (float)this.sourceH / (float)this.targetH;
            if (opScaleW != 1.0f || opScaleH != 1.0f) {
                sampler = Sampler2D.scale(sampler, opScaleW, opScaleH);
            }
            return sampler;
        }
    }

    public static class Builder {
        private final int originalFrameW;
        private final int originalFrameH;
        private final int targetFrameW;
        private final int targetFrameH;
        private final List<Operation> operations = new ArrayList<Operation>();
        private Integer fromX;
        private Integer fromY;
        private Integer fromW;
        private Integer fromH;
        private Integer targetX;
        private Integer targetY;
        private Integer targetW;
        private Integer targetH;
        private boolean flipX = false;
        private boolean flipY = false;
        private Rotation rotation = Rotation.NONE;
        private boolean bilinear = false;
        private boolean blended = false;
        @Nullable
        private List<Palette> palettes = null;

        public Builder(int originalW, int originalH, int targetW, int targetH) {
            this.originalFrameW = originalW;
            this.originalFrameH = originalH;
            this.targetFrameW = targetW;
            this.targetFrameH = targetH;
        }

        public TextureCollager build() {
            this.addLast();
            return new TextureCollager(this.originalFrameW, this.originalFrameH, this.targetFrameW, this.targetFrameH, List.copyOf(this.operations));
        }

        public Builder copyFrom(int x, int y, int w, int h) {
            this.addLast();
            this.fromX = x;
            this.fromY = y;
            this.fromW = w;
            this.targetH = this.fromH = Integer.valueOf(h);
            this.targetW = this.fromW;
            return this;
        }

        public Builder to(int x, int y, int w, int h) {
            this.to(x, y);
            this.targetW = w;
            this.targetH = h;
            return this;
        }

        public Builder to(int x, int y) {
            this.targetX = x;
            this.targetY = y;
            return this;
        }

        public Builder flippedX() {
            this.flipX = true;
            return this;
        }

        public Builder flippedY() {
            this.flipY = true;
            return this;
        }

        public Builder rotated(Rotation r) {
            this.rotation = r == null ? Rotation.NONE : r;
            return this;
        }

        public Builder blended() {
            this.blended = true;
            return this;
        }

        public Builder paletted(List<Palette> palettes) {
            this.palettes = palettes;
            return this;
        }

        public Builder bilinearScaling() {
            this.bilinear = true;
            return this;
        }

        private void addLast() {
            if (this.targetX == null) {
                return;
            }
            this.validate();
            if (this.targetW == null) {
                this.targetW = this.fromW;
            }
            if (this.targetH == null) {
                this.targetH = this.fromH;
            }
            this.operations.add(new Operation(this.fromX, this.fromY, this.fromW, this.fromH, this.targetX, this.targetY, this.targetW, this.targetH, this.flipX, this.flipY, this.rotation, this.bilinear, this.blended, this.palettes));
            this.fromH = null;
            this.fromW = null;
            this.fromY = null;
            this.fromX = null;
        }

        private void validate() {
            if (this.fromX == null) {
                throw new IllegalStateException("sourceX must be set");
            }
            if (this.fromY == null) {
                throw new IllegalStateException("sourceY must be set");
            }
            if (this.fromW == null) {
                throw new IllegalStateException("sourceW must be set");
            }
            if (this.fromH == null) {
                throw new IllegalStateException("sourceH must be set");
            }
            if (this.targetX == null) {
                throw new IllegalStateException("targetX must be set");
            }
            if (this.targetY == null) {
                throw new IllegalStateException("targetY must be set");
            }
            if (this.fromX < 0 || this.fromX + this.fromW > this.originalFrameW) {
                throw new IllegalArgumentException("Source rectangle out of bounds: fromX");
            }
            if (this.fromY < 0 || this.fromY + this.fromH > this.originalFrameH) {
                throw new IllegalArgumentException("Source rectangle out of bounds: fromY");
            }
            if (this.targetX < 0 || this.targetX + this.targetW > this.targetFrameW) {
                throw new IllegalArgumentException("Target rectangle out of bounds: targetX");
            }
            if (this.targetY < 0 || this.targetY + this.targetH > this.targetFrameH) {
                throw new IllegalArgumentException("Target rectangle out of bounds: targetY");
            }
        }
    }
}

