/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.debug.VoicechatUncaughtExceptionHandler;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.MicActivator;
import de.maxhenkel.voicechat.voice.client.MicThread;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.MicrophoneException;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.speaker.Speaker;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerManager;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MicTestButton
extends ToggleImageButton
implements ImageButton.TooltipSupplier {
    private static final ResourceLocation MICROPHONE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/microphone_button.png");
    private static final Component TEST_DISABLED = Component.translatable((String)"message.voicechat.mic_test.disabled");
    private static final Component TEST_ENABLED = Component.translatable((String)"message.voicechat.mic_test.enabled");
    private static final Component TEST_UNAVAILABLE = Component.translatable((String)"message.voicechat.mic_test_unavailable").withStyle(ChatFormatting.RED);
    private boolean micActive;
    @Nullable
    private VoiceThread voiceThread;
    private final MicListener micListener;
    @Nullable
    private final ClientVoicechat client;
    @Nullable
    private State lastState;

    public MicTestButton(int xIn, int yIn, MicListener micListener) {
        super(xIn, yIn, MICROPHONE, null, null, null);
        this.micListener = micListener;
        this.client = ClientManager.getClient();
        this.active = this.client == null || this.client.getSoundManager() != null;
        this.stateSupplier = () -> !this.micActive;
        this.tooltipSupplier = this;
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.renderWidget(guiGraphics, x, y, partialTicks);
        if (this.voiceThread != null) {
            this.voiceThread.updateLastRender();
        }
    }

    public void setMicActive(boolean micActive) {
        this.micActive = micActive;
    }

    @Override
    public void onPress() {
        this.setMicActive(!this.micActive);
        if (this.micActive) {
            this.close();
            try {
                this.voiceThread = new VoiceThread(e -> {
                    this.setMicActive(false);
                    this.active = false;
                    Voicechat.LOGGER.error("Microphone error", e);
                });
                this.voiceThread.start();
            }
            catch (Exception e2) {
                this.setMicActive(false);
                this.active = false;
                Voicechat.LOGGER.error("Microphone error", e2);
            }
        } else {
            this.close();
        }
    }

    private void close() {
        if (this.voiceThread != null) {
            this.voiceThread.close();
            this.voiceThread = null;
        }
    }

    public void stop() {
        this.close();
        this.setMicActive(false);
    }

    @Override
    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    @Override
    public void updateTooltip(ImageButton button) {
        State state = this.getState();
        if (state != this.lastState) {
            this.lastState = state;
            button.setTooltip(Tooltip.create((Component)state.getComponent()));
        }
    }

    private State getState() {
        if (!this.active) {
            return State.UNAVAILABLE;
        }
        if (this.micActive) {
            return State.ENABLED;
        }
        return State.DISABLED;
    }

    public static interface MicListener {
        public void onMicValue(double var1);
    }

    private class VoiceThread
    extends Thread {
        private final MicActivator micActivator;
        private final Speaker speaker;
        private boolean running = true;
        private long lastRender;
        private MicThread micThread;
        private boolean usesOwnMicThread;
        @Nullable
        private SoundManager ownSoundManager;

        public VoiceThread(Consumer<MicrophoneException> onMicError) throws SpeakerException {
            SoundManager soundManager;
            this.setDaemon(true);
            this.setName("VoiceTestingThread");
            this.setUncaughtExceptionHandler(new VoicechatUncaughtExceptionHandler());
            this.micActivator = new MicActivator();
            MicThread micThread = this.micThread = MicTestButton.this.client != null ? MicTestButton.this.client.getMicThread() : null;
            if (this.micThread == null) {
                this.micThread = new MicThread(MicTestButton.this.client, null, onMicError);
                this.usesOwnMicThread = true;
            } else {
                this.micThread.getError(onMicError);
            }
            if (MicTestButton.this.client == null) {
                this.ownSoundManager = soundManager = new SoundManager(VoicechatClient.CLIENT_CONFIG.speaker.get());
            } else {
                soundManager = MicTestButton.this.client.getSoundManager();
            }
            if (soundManager == null) {
                throw new SpeakerException("No sound manager");
            }
            this.speaker = SpeakerManager.createSpeaker(soundManager, null);
            this.updateLastRender();
            this.setMicLocked(true);
        }

        @Override
        public void run() {
            while (this.running && System.currentTimeMillis() - this.lastRender <= 500L) {
                short[] buff = this.micThread.pollMic();
                if (buff == null) continue;
                MicTestButton.this.micListener.onMicValue(Utils.dbToPerc(Utils.getHighestAudioLevel(buff)));
                if (VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE)) {
                    if (!this.micActivator.push(buff, a -> {})) continue;
                    this.play(buff);
                    continue;
                }
                this.micActivator.stopActivating();
                this.play(buff);
            }
            this.speaker.close();
            this.setMicLocked(false);
            MicTestButton.this.micListener.onMicValue(0.0);
            if (this.usesOwnMicThread) {
                this.micThread.close();
            }
            if (this.ownSoundManager != null) {
                this.ownSoundManager.close();
            }
            MicTestButton.this.setMicActive(false);
            Voicechat.LOGGER.info("Mic test audio channel closed", new Object[0]);
        }

        private void play(short[] buff) {
            this.speaker.play(buff, VoicechatClient.CLIENT_CONFIG.voiceChatVolume.get().floatValue(), null);
        }

        public void updateLastRender() {
            this.lastRender = System.currentTimeMillis();
        }

        private void setMicLocked(boolean locked) {
            this.micThread.setMicrophoneLocked(locked);
        }

        public void close() {
            if (!this.running) {
                return;
            }
            Voicechat.LOGGER.info("Stopping mic test audio channel", new Object[0]);
            this.running = false;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Voicechat.LOGGER.warn("Failed to close microphone", e);
            }
        }
    }

    private static enum State {
        ENABLED(TEST_ENABLED),
        DISABLED(TEST_DISABLED),
        UNAVAILABLE(TEST_UNAVAILABLE);

        private final Component component;

        private State(Component component) {
            this.component = component;
        }

        public Component getComponent() {
            return this.component;
        }
    }
}

