/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.mixins;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.slot.AppEngSlot;
import com.glodblock.github.extendedae.container.ContainerPatternModifier;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.patterns.AdvPatternDetailsEncoder;
import net.pedroksl.advanced_ae.common.patterns.AdvProcessingPattern;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ContainerPatternModifier.class})
public class MixinContainerPatternModifier
extends AEBaseMenu {
    @Final
    @Shadow(remap=false)
    public AppEngSlot replaceTarget;
    @Final
    @Shadow(remap=false)
    public AppEngSlot replaceWith;

    public MixinContainerPatternModifier(MenuType<?> menuType, int id, Inventory playerInventory, Object host) {
        super(menuType, id, playerInventory, host);
    }

    @Shadow(remap=false)
    private void replace(GenericStack[] stacks, GenericStack[] des, AEKey replace, AEKey with) {
    }

    @Shadow(remap=false)
    private ItemStack[] itemize(GenericStack[] stacks) {
        return null;
    }

    @Shadow(remap=false)
    private ItemStack itemize(GenericStack stack) {
        return null;
    }

    @Shadow(remap=false)
    private boolean checkModify(GenericStack[] stacks, int scale, boolean div) {
        return false;
    }

    @Shadow(remap=false)
    private void modifyStacks(GenericStack[] stacks, GenericStack[] des, int scale, boolean div) {
    }

    @Overwrite(remap=false)
    public void replace() {
        ItemStack replace = this.replaceTarget.getItem();
        ItemStack with = this.replaceWith.getItem();
        if (replace.isEmpty() || with.isEmpty()) {
            return;
        }
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            GenericStack[] replaceOutput;
            GenericStack[] replaceInput;
            GenericStack[] output;
            GenericStack[] input;
            ItemStack stack = slot.getItem();
            if (!(stack.getItem() instanceof EncodedPatternItem)) continue;
            IPatternDetails detail = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().level());
            if (detail instanceof AdvProcessingPattern) {
                AdvProcessingPattern processingPattern = (AdvProcessingPattern)detail;
                input = processingPattern.getSparseInputs().toArray(new GenericStack[0]);
                output = processingPattern.getOutputs().toArray(new GenericStack[0]);
                replaceInput = new GenericStack[input.length];
                replaceOutput = new GenericStack[output.length];
                this.replace(input, replaceInput, (AEKey)AEItemKey.of((ItemStack)replace), (AEKey)AEItemKey.of((ItemStack)with));
                this.replace(output, replaceOutput, (AEKey)AEItemKey.of((ItemStack)replace), (AEKey)AEItemKey.of((ItemStack)with));
                HashMap dirMap = processingPattern.getDirectionMap();
                HashMap<AEKey, Direction> newDirMap = new HashMap<AEKey, Direction>();
                for (Map.Entry entry : ((LinkedHashMap)dirMap).entrySet()) {
                    if (AEItemKey.matches((AEKey)((AEKey)entry.getKey()), (ItemStack)replace)) {
                        newDirMap.put((AEKey)AEItemKey.of((ItemStack)with), (Direction)entry.getValue());
                        continue;
                    }
                    newDirMap.put((AEKey)entry.getKey(), (Direction)entry.getValue());
                }
                ItemStack newPattern = AdvPatternDetailsEncoder.encodeProcessingPattern(Arrays.asList(replaceInput), Arrays.asList(replaceOutput), newDirMap);
                slot.set(newPattern);
                continue;
            }
            if (detail instanceof AEProcessingPattern) {
                AEProcessingPattern process = (AEProcessingPattern)detail;
                input = process.getSparseInputs().toArray(new GenericStack[0]);
                output = process.getOutputs().toArray(new GenericStack[0]);
                replaceInput = new GenericStack[input.length];
                replaceOutput = new GenericStack[output.length];
                this.replace(input, replaceInput, (AEKey)AEItemKey.of((ItemStack)replace), (AEKey)AEItemKey.of((ItemStack)with));
                this.replace(output, replaceOutput, (AEKey)AEItemKey.of((ItemStack)replace), (AEKey)AEItemKey.of((ItemStack)with));
                ItemStack newPattern = PatternDetailsHelper.encodeProcessingPattern(Arrays.asList(replaceInput), Arrays.asList(replaceOutput));
                slot.set(newPattern);
                continue;
            }
            if (!(detail instanceof AECraftingPattern)) continue;
            AECraftingPattern craft = (AECraftingPattern)detail;
            input = craft.getSparseInputs().toArray(new GenericStack[0]);
            output = craft.getPrimaryOutput();
            replaceInput = new GenericStack[input.length];
            this.replace(input, replaceInput, (AEKey)AEItemKey.of((ItemStack)replace), (AEKey)AEItemKey.of((ItemStack)with));
            try {
                ItemStack newPattern = PatternDetailsHelper.encodeCraftingPattern((RecipeHolder)Ae2Reflect.getCraftRecipe((AECraftingPattern)craft), (ItemStack[])this.itemize(replaceInput), (ItemStack)this.itemize((GenericStack)output), (boolean)craft.canSubstitute, (boolean)craft.canSubstituteFluids);
                AECraftingPattern check = new AECraftingPattern(AEItemKey.of((ItemStack)newPattern), this.getPlayer().level());
                if (check == null) continue;
                slot.set(newPattern);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    @Overwrite(remap=false)
    public void modify(int scale, boolean div) {
        if (scale <= 0) {
            return;
        }
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            GenericStack[] mulOutput;
            GenericStack[] mulInput;
            GenericStack[] output;
            GenericStack[] input;
            ItemStack stack = slot.getItem();
            if (!(stack.getItem() instanceof EncodedPatternItem)) continue;
            IPatternDetails detail = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().level());
            if (detail instanceof AdvProcessingPattern) {
                AdvProcessingPattern processingPattern = (AdvProcessingPattern)detail;
                input = processingPattern.getSparseInputs().toArray(new GenericStack[0]);
                output = processingPattern.getOutputs().toArray(new GenericStack[0]);
                if (!this.checkModify(input, scale, div) || !this.checkModify(output, scale, div)) continue;
                mulInput = new GenericStack[input.length];
                mulOutput = new GenericStack[output.length];
                this.modifyStacks(input, mulInput, scale, div);
                this.modifyStacks(output, mulOutput, scale, div);
                HashMap dirMap = processingPattern.getDirectionMap();
                ItemStack newPattern = AdvPatternDetailsEncoder.encodeProcessingPattern(Arrays.asList(mulInput), Arrays.asList(mulOutput), dirMap);
                slot.set(newPattern);
                continue;
            }
            if (!(detail instanceof AEProcessingPattern)) continue;
            AEProcessingPattern process = (AEProcessingPattern)detail;
            input = process.getSparseInputs().toArray(new GenericStack[0]);
            output = process.getOutputs().toArray(new GenericStack[0]);
            if (!this.checkModify(input, scale, div) || !this.checkModify(output, scale, div)) continue;
            mulInput = new GenericStack[input.length];
            mulOutput = new GenericStack[output.length];
            this.modifyStacks(input, mulInput, scale, div);
            this.modifyStacks(output, mulOutput, scale, div);
            ItemStack newPattern = PatternDetailsHelper.encodeProcessingPattern(Arrays.asList(mulInput), Arrays.asList(mulOutput));
            slot.set(newPattern);
        }
    }
}

