/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.transformer;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.ast.data.ChildNodeList;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.Version;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.node.abstract_node.InnerASTNode;
import io.github.douira.glsl_transformer.ast.node.declaration.Declaration;
import io.github.douira.glsl_transformer.ast.node.declaration.DeclarationMember;
import io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.AssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.MemberAccessExpression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.FunctionDefinition;
import io.github.douira.glsl_transformer.ast.node.statement.CompoundStatement;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.RootSupplier;
import io.github.douira.glsl_transformer.ast.query.index.ExternalDeclarationIndex;
import io.github.douira.glsl_transformer.ast.query.index.IdentifierIndex;
import io.github.douira.glsl_transformer.ast.query.index.SuperclassNodeIndex;
import io.github.douira.glsl_transformer.ast.query.match.AutoHintedMatcher;
import io.github.douira.glsl_transformer.ast.transform.ASTBuilder;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.JobParameters;
import io.github.douira.glsl_transformer.ast.transform.SingleASTTransformer;
import io.github.douira.glsl_transformer.ast.traversal.ASTBaseVisitor;
import io.github.douira.glsl_transformer.ast.traversal.ASTVisitor;
import io.github.douira.glsl_transformer.parser.ParseShape;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.irisshaders.iris.helpers.StringPair;
import net.irisshaders.iris.shaderpack.parsing.CommentDirective;
import net.irisshaders.iris.shaderpack.parsing.CommentDirectiveParser;
import net.irisshaders.iris.shaderpack.preprocessor.JcppProcessor;
import top.leonx.irisflw.IrisFlw;

public class GlslTransformerFragPatcher {
    static final String FLW_VERTEX_POS_DECL = "flw_vertexPos";
    static final String flw_vertexTexCoord = "flw_vertexTexCoord";
    static final String flw_vertexColor = "flw_vertexColor";
    static final String flw_vertexOverlay = "flw_vertexOverlay";
    static final String flw_vertexLight = "flw_vertexLight";
    static final String flw_vertexNormal = "flw_vertexNormal";
    private final SingleASTTransformer<ContextParameter> transformer = new SingleASTTransformer<ContextParameter>(){
        {
            this.setRootSupplier(RootSupplier.PREFIX_UNORDERED_ED_EXACT);
        }

        public TranslationUnit parseTranslationUnit(Root rootInstance, String input) {
            Matcher matcher = versionPattern.matcher(input);
            if (!matcher.find()) {
                throw new IllegalArgumentException("No #version directive found in source code! See debugging.md for more information.");
            }
            int versionNum = Integer.parseInt(matcher.group(1));
            if (versionNum < 330) {
                versionNum = 330;
                String ignored = matcher.replaceAll("#version 330");
                IrisFlw.LOGGER.warn("GLSL version is lower than 330, set to 330");
            }
            GlslTransformerFragPatcher.this.transformer.getLexer().version = Version.fromNumber((int)versionNum);
            return super.parseTranslationUnit(rootInstance, input);
        }
    };
    private final SingleASTTransformer<ContextParameter> flwTransformer;
    public static final AutoHintedMatcher<Expression> glTextureMatrix0 = new AutoHintedMatcher("gl_TextureMatrix[0]", ParseShape.EXPRESSION);
    public static final AutoHintedMatcher<Expression> glTextureMatrix1 = new AutoHintedMatcher("gl_TextureMatrix[1]", ParseShape.EXPRESSION);
    public static final AutoHintedMatcher<Expression> glTextureMatrix2 = new AutoHintedMatcher("gl_TextureMatrix[2]", ParseShape.EXPRESSION);
    public static final Set<String> toRemoveAttributesSet = Set.of("at_tangent", "at_midBlock", "mc_Entity", "mc_midTexCoord");
    public static final AutoHintedMatcher<Expression> ftransformExpr = new AutoHintedMatcher("ftransform()", ParseShape.EXPRESSION);
    public static final ASTVisitor<Boolean> vNormalMemberReassignMatchVisitor = new ReassignMatcherVisitor("v", "normal");
    public static final ASTVisitor<Boolean> vTexCoordsMemberReassignMatchVisitor = new ReassignMatcherVisitor("v", "texCoords");
    private static final ParseShape<GLSLParser.CompoundStatementContext, CompoundStatement> CompoundStatementShape = new ParseShape(GLSLParser.CompoundStatementContext.class, GLSLParser::compoundStatement, ASTBuilder::visitCompoundStatement);
    private static final Pattern boxCoordDetector = Pattern.compile("BoxCoord");
    private static final Pattern versionPattern = Pattern.compile("^.*#version\\s+(\\d+)", 32);
    private static final boolean useLightSector = false;

    public GlslTransformerFragPatcher() {
        this.transformer.setParseLineDirectives(true);
        this.transformer.setTransformation(this::transform);
        this.flwTransformer = new SingleASTTransformer();
        this.flwTransformer.setRootSupplier(new RootSupplier(SuperclassNodeIndex::withOrdered, IdentifierIndex::withOnlyExact, ExternalDeclarationIndex::withOnlyExactOrdered));
        this.flwTransformer.getLexer().version = Version.GLSL33;
    }

    private void transform(TranslationUnit tree, Root root, ContextParameter parameter) {
        String vertexTemplate = parameter.flwTemplate;
        String processedFlwSource = JcppProcessor.glslPreprocessSource((String)vertexTemplate, List.of(new StringPair("FRAGMENT_SHADER", "1")));
        parameter.flwTree = this.flwTransformer.parseSeparateTranslationUnit(processedFlwSource);
        ChildNodeList<ExternalDeclaration> predefinesStats = this.ProcessFlywheelPredefine(tree, parameter);
        tree.injectNodes(ASTInjectionPoint.BEFORE_DECLARATIONS, predefinesStats);
    }

    private static void RemoveOriginalAttributes(Root root, Map<String, Integer> attrVectorDims) {
        root.process(root.nodeIndex.getStream(DeclarationExternalDeclaration.class).distinct(), node -> {
            TypeAndInitDeclaration typeAndInitDeclaration;
            Optional<DeclarationMember> foundMember;
            Declaration patt0$temp = node.getDeclaration();
            if (patt0$temp instanceof TypeAndInitDeclaration && (foundMember = (typeAndInitDeclaration = (TypeAndInitDeclaration)patt0$temp).getMembers().stream().filter(member -> toRemoveAttributesSet.contains(member.getName().getName())).findAny()).isPresent()) {
                TypeSpecifier patt1$temp = typeAndInitDeclaration.getType().getTypeSpecifier();
                if (patt1$temp instanceof BuiltinNumericTypeSpecifier) {
                    BuiltinNumericTypeSpecifier numericTypeSpecifier = (BuiltinNumericTypeSpecifier)patt1$temp;
                    String name = foundMember.get().getName().getName();
                    int[] dimensions = numericTypeSpecifier.type.getDimensions();
                    int dim = dimensions.length > 0 ? dimensions[0] : 1;
                    attrVectorDims.put(name, dim);
                }
                node.detachAndDelete();
            }
        });
    }

    private ChildNodeList<ExternalDeclaration> ProcessFlywheelPredefine(TranslationUnit tree, ContextParameter parameter) {
        TranslationUnit flwTree = parameter.flwTree;
        String flwSource = parameter.flwTemplate;
        Root flwPredefineRoot = flwTree.getRoot();
        ExternalDeclaration mainFunc = (ExternalDeclaration)flwTree.getOneMainDefinitionBody().getAncestor(ExternalDeclaration.class);
        HashSet toRenameSet = new HashSet();
        flwTree.getRoot().process(flwTree.getChildren().stream().filter(x -> x != mainFunc), node -> {
            TypeAndInitDeclaration typeAndInitDeclaration;
            TypeSpecifier typeSpecifier;
            DeclarationExternalDeclaration declarationExternalDeclaration;
            Declaration declaration;
            if (node instanceof FunctionDefinition) {
                FunctionDefinition functionDefinition = (FunctionDefinition)node;
                String functionName = functionDefinition.getFunctionPrototype().getName().getName();
                if (!functionName.toLowerCase().startsWith("flw") && !functionName.toLowerCase().startsWith("_flw")) {
                    toRenameSet.add(functionName);
                }
            } else if (node instanceof DeclarationExternalDeclaration && (declaration = (declarationExternalDeclaration = (DeclarationExternalDeclaration)node).getDeclaration()) instanceof TypeAndInitDeclaration && (typeSpecifier = (typeAndInitDeclaration = (TypeAndInitDeclaration)declaration).getType().getTypeSpecifier()) instanceof BuiltinNumericTypeSpecifier) {
                BuiltinNumericTypeSpecifier numericTypeSpecifier = (BuiltinNumericTypeSpecifier)typeSpecifier;
                Stream<String> names = typeAndInitDeclaration.getMembers().stream().map(member -> member.getName().getName()).filter(name -> !name.toLowerCase().startsWith("flw") && !name.toLowerCase().startsWith("_flw"));
                toRenameSet.addAll(names.collect(Collectors.toSet()));
            }
        });
        toRenameSet.forEach(name -> {
            String newName = "flw_" + name;
            flwTree.getRoot().rename(name, newName);
        });
        return ChildNodeList.collect(flwTree.getChildren().stream().filter(x -> x != mainFunc), (InnerASTNode)flwTree);
    }

    private void replaceReferenceExpressionsWithCorrectSwizzle(Root root, SingleASTTransformer<ContextParameter> transformer, String name, String expression, int dimension) {
        root.process(root.identifierIndex.getStream(name), identifier -> {
            ASTNode parent = identifier.getParent();
            if (!(parent instanceof ReferenceExpression)) {
                return;
            }
            ReferenceExpression referenceExpression = (ReferenceExpression)parent;
            if (referenceExpression.getParent() instanceof MemberAccessExpression) {
                parent.replaceByAndDelete((ASTNode)transformer.parseExpression(identifier.getRoot(), expression));
            } else {
                parent.replaceByAndDelete((ASTNode)transformer.parseExpression(identifier.getRoot(), this.getSwizzleFromDimension(expression, dimension)));
            }
        });
    }

    private String getSwizzleFromDimension(String identifierName, int dimension) {
        return identifierName + (switch (dimension) {
            case 1 -> ".x";
            case 2 -> ".xy";
            case 3 -> ".xyz";
            case 4 -> ".xyzw";
            default -> "";
        });
    }

    private String getZeroFromDimension(int dimension) {
        return switch (dimension) {
            case 1 -> "0.0";
            case 2 -> "vec2(0.0)";
            case 3 -> "vec3(0.0)";
            case 4 -> "vec4(0.0)";
            default -> "";
        };
    }

    public String patch(String irisSource, String flwSource) {
        Optional drawBufferDirectives = CommentDirectiveParser.findDirective((String)irisSource, (CommentDirective.Type)CommentDirective.Type.DRAWBUFFERS);
        Optional renderTargetDirectives = CommentDirectiveParser.findDirective((String)irisSource, (CommentDirective.Type)CommentDirective.Type.RENDERTARGETS);
        String transformed = (String)this.transformer.transform((Object)irisSource, (Object)new ContextParameter(flwSource));
        StringBuffer sb = new StringBuffer();
        drawBufferDirectives.ifPresent(directive -> {
            sb.append("/* DRAWBUFFERS:");
            sb.append(directive.getDirective());
            sb.append(" */\n");
        });
        renderTargetDirectives.ifPresent(directive -> {
            sb.append("/* RENDERTARGETS:");
            sb.append(directive.getDirective());
            sb.append(" */\n");
        });
        sb.append(transformed);
        return sb.toString();
    }

    public static class ContextParameter
    implements JobParameters {
        public boolean hasBoxCoord;
        public String flwTemplate;
        public TranslationUnit flwTree;

        public ContextParameter(String flwVertexSource) {
            this.flwTemplate = flwVertexSource;
        }
    }

    private static class ReassignMatcherVisitor
    extends ASTBaseVisitor<Boolean> {
        private final String targetName;
        private final String targetMember;
        private boolean isTargetMemberAccess = false;

        public ReassignMatcherVisitor(String targetName, String targetMember) {
            this.targetName = targetName;
            this.targetMember = targetMember;
        }

        private boolean isVNormalMemberAccess(ASTNode node) {
            if (node instanceof MemberAccessExpression) {
                ReferenceExpression referenceExpression;
                Expression expression;
                MemberAccessExpression memberAccessExpression = (MemberAccessExpression)node;
                return memberAccessExpression.getMember().getName().equals(this.targetMember) && (expression = memberAccessExpression.getOperand()) instanceof ReferenceExpression && (referenceExpression = (ReferenceExpression)expression).getIdentifier().getName().equals(this.targetName);
            }
            return false;
        }

        public Boolean startVisit(ASTNode node) {
            this.isTargetMemberAccess = false;
            return (Boolean)super.startVisit(node);
        }

        public Boolean visitRaw(ASTNode node) {
            MemberAccessExpression memberAccessExpression;
            if (node instanceof AssignmentExpression) {
                MemberAccessExpression memberAccessExpression2;
                boolean leftIsVNormal;
                AssignmentExpression assignmentExpression = (AssignmentExpression)node;
                Expression left = assignmentExpression.getLeft();
                if (left instanceof MemberAccessExpression && (leftIsVNormal = this.isVNormalMemberAccess((ASTNode)(memberAccessExpression2 = (MemberAccessExpression)left)))) {
                    Expression right = assignmentExpression.getRight();
                    this.isTargetMemberAccess = true;
                    return (Boolean)right.accept((ASTVisitor)this);
                }
            } else if (this.isTargetMemberAccess && node instanceof MemberAccessExpression && this.isVNormalMemberAccess((ASTNode)(memberAccessExpression = (MemberAccessExpression)node))) {
                return true;
            }
            return (Boolean)node.accept((ASTVisitor)this);
        }

        public Boolean defaultResult() {
            return false;
        }

        public Boolean aggregateResult(Boolean aggregate, Boolean nextResult) {
            return aggregate != false || nextResult != false;
        }
    }
}

