/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.stateobserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.favouriteless.stateobserver.api.GlobalStateListener;
import net.favouriteless.stateobserver.api.StateObserver;
import net.favouriteless.stateobserver.api.StateObserverManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class StateObserverManagerImpl
implements StateObserverManager {
    public static final StateObserverManagerImpl INSTANCE = new StateObserverManagerImpl();
    private final Map<ChunkPos, Set<StateObserver>> observers = new HashMap<ChunkPos, Set<StateObserver>>();
    private final List<GlobalStateListener> globalListeners = new ArrayList<GlobalStateListener>();

    @Override
    public <T extends StateObserver> T addObserver(T observer) {
        this.getObservedChunks(observer).forEach(c -> this.observers.computeIfAbsent((ChunkPos)c, k -> new HashSet()).add(observer));
        observer.onInit();
        return observer;
    }

    @Override
    public void removeObserver(StateObserver observer) {
        observer.onRemove();
        this.getObservedChunks(observer).forEach(c -> Optional.ofNullable(this.observers.get(c)).ifPresent(s -> s.remove(observer)));
    }

    @Override
    public <T extends StateObserver> T getObserver(Level level, BlockPos pos, Class<T> clazz) {
        ChunkPos chunkPos = new ChunkPos(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        if (!this.observers.containsKey(chunkPos)) {
            return null;
        }
        for (StateObserver observer : this.observers.get(chunkPos)) {
            if (observer.getClass() != clazz || observer.getLevel() != level || !observer.getPos().equals((Object)pos)) continue;
            return (T)observer;
        }
        return null;
    }

    @Override
    public void registerGlobalListener(GlobalStateListener listener) {
        this.globalListeners.add(listener);
    }

    public void notifyChange(ServerLevel level, BlockPos pos, BlockState oldState, BlockState newState) {
        this.globalListeners.forEach(l -> l.notify(level, pos, oldState, newState));
        ChunkPos chunkPos = new ChunkPos(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        if (!this.observers.containsKey(chunkPos)) {
            return;
        }
        for (StateObserver observer : this.observers.get(chunkPos)) {
            if (level != observer.getLevel() || !observer.isWithinBounds(pos)) continue;
            observer.getChangeSet().change(pos, oldState, newState);
        }
    }

    protected Stream<ChunkPos> getObservedChunks(StateObserver observer) {
        BlockPos center = observer.getPos();
        return ChunkPos.rangeClosed((ChunkPos)new ChunkPos(SectionPos.blockToSectionCoord((int)(center.getX() - observer.getRadiusX())), SectionPos.blockToSectionCoord((int)(center.getZ() - observer.getRadiusZ()))), (ChunkPos)new ChunkPos(SectionPos.blockToSectionCoord((int)(center.getX() + observer.getRadiusX())), SectionPos.blockToSectionCoord((int)(center.getZ() + observer.getRadiusZ()))));
    }

    public void reset() {
        this.observers.clear();
    }
}

