/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BonemealableTallGrassBlock
extends BushBlock
implements BonemealableBlock {
    private final Supplier<Block> tallVariant;
    public static final MapCodec<BonemealableTallGrassBlock> CODEC = BonemealableTallGrassBlock.simpleCodec(props -> new BonemealableTallGrassBlock((BlockBehaviour.Properties)props, () -> null));

    public BonemealableTallGrassBlock(BlockBehaviour.Properties properties, Supplier<Block> tallVariant) {
        super(properties);
        this.tallVariant = tallVariant;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        DoublePlantBlock doublePlantBlock;
        Block tallGrass = this.tallVariant.get();
        if (tallGrass instanceof DoublePlantBlock && (doublePlantBlock = (DoublePlantBlock)tallGrass).defaultBlockState().canSurvive((LevelReader)serverLevel, blockPos) && serverLevel.isEmptyBlock(blockPos.above())) {
            DoublePlantBlock.placeAt((LevelAccessor)serverLevel, (BlockState)doublePlantBlock.defaultBlockState(), (BlockPos)blockPos, (int)2);
        }
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }
}

