/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.block;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.LightEngine;
import net.satisfy.bloomingnature.core.registry.ObjectRegistry;

public class LateritGrassBlock
extends SnowyDirtBlock
implements BonemealableBlock {
    public LateritGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean canBeGrass(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockPos blockPos2 = blockPos.above();
        BlockState blockState2 = levelReader.getBlockState(blockPos2);
        if (blockState2.is(Blocks.SNOW) && (Integer)blockState2.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (blockState2.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockGetter)levelReader, (BlockState)blockState, (BlockPos)blockPos, (BlockState)blockState2, (BlockPos)blockPos2, (Direction)Direction.UP, (int)blockState2.getLightBlock((BlockGetter)levelReader, blockPos2));
        return i < levelReader.getMaxLightLevel();
    }

    private static boolean canPropagate(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockPos blockPos2 = blockPos.above();
        return LateritGrassBlock.canBeGrass(blockState, levelReader, blockPos) && !levelReader.getFluidState(blockPos2).is(FluidTags.WATER);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return levelReader.getBlockState(blockPos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        BlockPos blockPos2 = blockPos.above();
        BlockState blockState2 = Blocks.GRASS_BLOCK.defaultBlockState();
        Optional optional = serverLevel.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getHolder(VegetationPlacements.GRASS_BONEMEAL);
        block0: for (int i = 0; i < 128; ++i) {
            Holder holder;
            BlockPos blockPos3 = blockPos2;
            for (int j = 0; j < i / 16; ++j) {
                if (!serverLevel.getBlockState((blockPos3 = blockPos3.offset(randomSource.nextInt(3) - 1, (randomSource.nextInt(3) - 1) * randomSource.nextInt(3) / 2, randomSource.nextInt(3) - 1)).below()).is((Block)this) || serverLevel.getBlockState(blockPos3).isCollisionShapeFullBlock((BlockGetter)serverLevel, blockPos3)) continue block0;
            }
            BlockState blockState3 = serverLevel.getBlockState(blockPos3);
            if (blockState3.is(blockState2.getBlock()) && randomSource.nextInt(10) == 0) {
                ((BonemealableBlock)blockState2.getBlock()).performBonemeal(serverLevel, randomSource, blockPos3, blockState3);
            }
            if (!blockState3.isAir()) continue;
            if (randomSource.nextInt(8) == 0) {
                List list = ((Biome)serverLevel.getBiome(blockPos3).value()).getGenerationSettings().getFlowerFeatures();
                if (list.isEmpty()) continue;
                holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).config()).feature();
            } else {
                if (optional.isEmpty()) continue;
                holder = (Holder)optional.get();
            }
            ((PlacedFeature)holder.value()).place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), randomSource, blockPos3);
        }
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!LateritGrassBlock.canBeGrass(blockState, (LevelReader)serverLevel, blockPos)) {
            serverLevel.setBlockAndUpdate(blockPos, ((Block)ObjectRegistry.LATERIT.get()).defaultBlockState());
        } else if (serverLevel.getMaxLocalRawBrightness(blockPos.above()) >= 9) {
            BlockState blockState2 = this.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockPos2 = blockPos.offset(randomSource.nextInt(3) - 1, randomSource.nextInt(5) - 3, randomSource.nextInt(3) - 1);
                if (!serverLevel.getBlockState(blockPos2).is((Block)ObjectRegistry.LATERIT.get()) || !LateritGrassBlock.canPropagate(blockState2, (LevelReader)serverLevel, blockPos2)) continue;
                serverLevel.setBlockAndUpdate(blockPos2, (BlockState)blockState2.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(serverLevel.getBlockState(blockPos2.above()).is(Blocks.SNOW))));
            }
        }
    }
}

