/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.util;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class BloomingNatureGeneralUtil {
    public static <T extends Block> RegistrySupplier<T> registerWithItem(DeferredRegister<Block> registerB, Registrar<Block> registrarB, DeferredRegister<Item> registerI, Registrar<Item> registrarI, ResourceLocation name, Supplier<T> block) {
        RegistrySupplier toReturn = BloomingNatureGeneralUtil.registerWithoutItem(registerB, registrarB, name, block);
        BloomingNatureGeneralUtil.registerItem(registerI, registrarI, name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(DeferredRegister<Block> register, Registrar<Block> registrar, ResourceLocation path, Supplier<T> block) {
        return Platform.isNeoForge() ? register.register(path.getPath(), block) : registrar.register(path, block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(DeferredRegister<Item> register, Registrar<Item> registrar, ResourceLocation path, Supplier<T> itemSupplier) {
        return Platform.isNeoForge() ? register.register(path.getPath(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static class BloomingNatureVillagerUtil {

        public static class SellItemFactory
        implements VillagerTrades.ItemListing {
            private final ItemStack sell;
            private final int price;
            private final int count;
            private final int maxUses;
            private final int experience;
            private final float multiplier;

            public SellItemFactory(Block block, int price, int count, int maxUses, int experience) {
                this(new ItemStack((ItemLike)block), price, count, maxUses, experience);
            }

            public SellItemFactory(ItemStack stack, int price, int count, int maxUses, int experience) {
                this(stack, price, count, maxUses, experience, 0.05f);
            }

            public SellItemFactory(ItemStack stack, int price, int count, int maxUses, int experience, float multiplier) {
                this.sell = stack;
                this.price = price;
                this.count = count;
                this.maxUses = maxUses;
                this.experience = experience;
                this.multiplier = multiplier;
            }

            public MerchantOffer getOffer(Entity entity, RandomSource random) {
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.price), new ItemStack((ItemLike)this.sell.getItem(), this.count), this.maxUses, this.experience, this.multiplier);
            }
        }
    }
}

