/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.curios.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class CurioZRingOffHandRenderer
implements ICurioRenderer {
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (stack.isEmpty()) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        matrixStack.pushPose();
        HumanoidArm offhandArm = entity.getMainArm() == HumanoidArm.RIGHT ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        EntityModel entityModel = renderLayerParent.getModel();
        if (entityModel instanceof ArmedModel) {
            ArmedModel model = (ArmedModel)entityModel;
            model.translateToHand(offhandArm, matrixStack);
            matrixStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            if (offhandArm == HumanoidArm.RIGHT) {
                matrixStack.translate(0.0625f, 0.125f, -0.5f);
            } else {
                matrixStack.translate(-0.0625f, 0.125f, -0.5f);
            }
        }
        ItemDisplayContext context = offhandArm == HumanoidArm.LEFT ? ItemDisplayContext.THIRD_PERSON_LEFT_HAND : ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        Minecraft.getInstance().getItemRenderer().renderStatic(entity, stack, context, offhandArm == HumanoidArm.LEFT, matrixStack, renderTypeBuffer, entity.level(), light, OverlayTexture.NO_OVERLAY, 0);
        matrixStack.popPose();
    }
}

